/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.CryptoInfo;
import java.nio.ByteBuffer;

public final class SampleHolder {
    public static final int BUFFER_REPLACEMENT_MODE_DISABLED = 0;
    public static final int BUFFER_REPLACEMENT_MODE_NORMAL = 1;
    public static final int BUFFER_REPLACEMENT_MODE_DIRECT = 2;
    public final CryptoInfo cryptoInfo = new CryptoInfo();
    public ByteBuffer data;
    public int size;
    public int flags;
    public long timeUs;
    private final int bufferReplacementMode;

    public SampleHolder(int n) {
        this.bufferReplacementMode = n;
    }

    public void ensureSpaceForWrite(int n) throws IllegalStateException {
        int n2;
        int n3;
        if (this.data == null) {
            this.data = this.createReplacementBuffer(n);
            return;
        }
        int n4 = this.data.capacity();
        if (n4 >= (n3 = (n2 = this.data.position()) + n)) {
            return;
        }
        ByteBuffer byteBuffer = this.createReplacementBuffer(n3);
        if (n2 > 0) {
            this.data.position(0);
            this.data.limit(n2);
            byteBuffer.put(this.data);
        }
        this.data = byteBuffer;
    }

    public boolean isEncrypted() {
        return (this.flags & 2) != 0;
    }

    public boolean isDecodeOnly() {
        return (this.flags & 0x8000000) != 0;
    }

    public boolean isSyncFrame() {
        return (this.flags & 1) != 0;
    }

    public void clearData() {
        if (this.data != null) {
            this.data.clear();
        }
    }

    private ByteBuffer createReplacementBuffer(int n) {
        if (this.bufferReplacementMode == 1) {
            return ByteBuffer.allocate(n);
        }
        if (this.bufferReplacementMode == 2) {
            return ByteBuffer.allocateDirect(n);
        }
        int n2 = this.data == null ? 0 : this.data.capacity();
        throw new IllegalStateException("Buffer too small (" + n2 + " < " + n + ")");
    }
}

