/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.eia608;

import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.text.eia608.ClosedCaption;
import com.google.android.exoplayer.text.eia608.ClosedCaptionCtrl;
import com.google.android.exoplayer.text.eia608.ClosedCaptionList;
import com.google.android.exoplayer.text.eia608.ClosedCaptionText;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;

public final class Eia608Parser {
    private static final int PAYLOAD_TYPE_CC = 4;
    private static final int COUNTRY_CODE = 181;
    private static final int PROVIDER_CODE = 49;
    private static final int USER_ID = 1195456820;
    private static final int USER_DATA_TYPE_CODE = 3;
    private static final int[] BASIC_CHARACTER_SET = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 225, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 233, 93, 237, 243, 250, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 231, 247, 209, 241, 9632};
    private static final int[] SPECIAL_CHARACTER_SET = new int[]{174, 176, 189, 191, 8482, 162, 163, 9834, 224, 32, 232, 226, 234, 238, 244, 251};
    private static final int[] SPECIAL_ES_FR_CHARACTER_SET = new int[]{193, 201, 211, 218, 220, 252, 8216, 161, 42, 39, 8212, 169, 8480, 8226, 8220, 8221, 192, 194, 199, 200, 202, 203, 235, 206, 207, 239, 212, 217, 249, 219, 171, 187};
    private static final int[] SPECIAL_PT_DE_CHARACTER_SET = new int[]{195, 227, 205, 204, 236, 210, 242, 213, 245, 123, 125, 92, 94, 95, 124, 126, 196, 228, 214, 246, 223, 165, 164, 9474, 197, 229, 216, 248, 9484, 9488, 9492, 9496};
    private final ParsableBitArray seiBuffer = new ParsableBitArray();
    private final StringBuilder stringBuilder = new StringBuilder();
    private final ArrayList<ClosedCaption> captions = new ArrayList();

    Eia608Parser() {
    }

    boolean canParse(String string) {
        return string.equals("application/eia-608");
    }

    ClosedCaptionList parse(SampleHolder sampleHolder) {
        if (sampleHolder.size < 10) {
            return null;
        }
        this.captions.clear();
        this.stringBuilder.setLength(0);
        this.seiBuffer.reset(sampleHolder.data.array());
        this.seiBuffer.skipBits(67);
        int n = this.seiBuffer.readBits(5);
        this.seiBuffer.skipBits(8);
        for (int i = 0; i < n; ++i) {
            this.seiBuffer.skipBits(5);
            boolean bl = this.seiBuffer.readBit();
            if (!bl) {
                this.seiBuffer.skipBits(18);
                continue;
            }
            int n2 = this.seiBuffer.readBits(2);
            if (n2 != 0) {
                this.seiBuffer.skipBits(16);
                continue;
            }
            this.seiBuffer.skipBits(1);
            byte by = (byte)this.seiBuffer.readBits(7);
            this.seiBuffer.skipBits(1);
            byte by2 = (byte)this.seiBuffer.readBits(7);
            if (by == 0 && by2 == 0) continue;
            if ((by == 17 || by == 25) && (by2 & 0x70) == 48) {
                this.stringBuilder.append(Eia608Parser.getSpecialChar(by2));
                continue;
            }
            if ((by == 18 || by == 26) && (by2 & 0x60) == 32) {
                this.backspace();
                this.stringBuilder.append(Eia608Parser.getExtendedEsFrChar(by2));
                continue;
            }
            if ((by == 19 || by == 27) && (by2 & 0x60) == 32) {
                this.backspace();
                this.stringBuilder.append(Eia608Parser.getExtendedPtDeChar(by2));
                continue;
            }
            if (by < 32) {
                this.addCtrl(by, by2);
                continue;
            }
            this.stringBuilder.append(Eia608Parser.getChar(by));
            if (by2 < 32) continue;
            this.stringBuilder.append(Eia608Parser.getChar(by2));
        }
        this.addBufferedText();
        if (this.captions.isEmpty()) {
            return null;
        }
        ClosedCaption[] closedCaptionArray = new ClosedCaption[this.captions.size()];
        this.captions.toArray(closedCaptionArray);
        return new ClosedCaptionList(sampleHolder.timeUs, sampleHolder.isDecodeOnly(), closedCaptionArray);
    }

    private static char getChar(byte by) {
        int n = (by & 0x7F) - 32;
        return (char)BASIC_CHARACTER_SET[n];
    }

    private static char getSpecialChar(byte by) {
        int n = by & 0xF;
        return (char)SPECIAL_CHARACTER_SET[n];
    }

    private static char getExtendedEsFrChar(byte by) {
        int n = by & 0x1F;
        return (char)SPECIAL_ES_FR_CHARACTER_SET[n];
    }

    private static char getExtendedPtDeChar(byte by) {
        int n = by & 0x1F;
        return (char)SPECIAL_PT_DE_CHARACTER_SET[n];
    }

    private void addBufferedText() {
        if (this.stringBuilder.length() > 0) {
            this.captions.add(new ClosedCaptionText(this.stringBuilder.toString()));
            this.stringBuilder.setLength(0);
        }
    }

    private void addCtrl(byte by, byte by2) {
        this.addBufferedText();
        this.captions.add(new ClosedCaptionCtrl(by, by2));
    }

    private void backspace() {
        this.addCtrl((byte)20, (byte)33);
    }

    public static boolean isSeiMessageEia608(int n, int n2, ParsableByteArray parsableByteArray) {
        if (n != 4 || n2 < 8) {
            return false;
        }
        int n3 = parsableByteArray.getPosition();
        int n4 = parsableByteArray.readUnsignedByte();
        int n5 = parsableByteArray.readUnsignedShort();
        int n6 = parsableByteArray.readInt();
        int n7 = parsableByteArray.readUnsignedByte();
        parsableByteArray.setPosition(n3);
        return n4 == 181 && n5 == 49 && n6 == 1195456820 && n7 == 3;
    }
}

