/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.text.PlayableSubtitle;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

final class SubtitleParserHelper
implements Handler.Callback {
    private static final int MSG_FORMAT = 0;
    private static final int MSG_SAMPLE = 1;
    private final SubtitleParser parser;
    private final Handler handler;
    private SampleHolder sampleHolder;
    private boolean parsing;
    private PlayableSubtitle result;
    private IOException error;
    private RuntimeException runtimeError;
    private boolean subtitlesAreRelative;
    private long subtitleOffsetUs;

    public SubtitleParserHelper(Looper looper, SubtitleParser subtitleParser) {
        this.handler = new Handler(looper, (Handler.Callback)this);
        this.parser = subtitleParser;
        this.flush();
    }

    public synchronized void flush() {
        this.sampleHolder = new SampleHolder(1);
        this.parsing = false;
        this.result = null;
        this.error = null;
        this.runtimeError = null;
    }

    public synchronized boolean isParsing() {
        return this.parsing;
    }

    public synchronized SampleHolder getSampleHolder() {
        return this.sampleHolder;
    }

    public void setFormat(MediaFormat mediaFormat) {
        this.handler.obtainMessage(0, (Object)mediaFormat).sendToTarget();
    }

    public synchronized void startParseOperation() {
        Assertions.checkState(!this.parsing);
        this.parsing = true;
        this.result = null;
        this.error = null;
        this.runtimeError = null;
        this.handler.obtainMessage(1, Util.getTopInt(this.sampleHolder.timeUs), Util.getBottomInt(this.sampleHolder.timeUs), (Object)this.sampleHolder).sendToTarget();
    }

    public synchronized PlayableSubtitle getAndClearResult() throws IOException {
        try {
            if (this.error != null) {
                throw this.error;
            }
            if (this.runtimeError != null) {
                throw this.runtimeError;
            }
            PlayableSubtitle playableSubtitle = this.result;
            return playableSubtitle;
        }
        finally {
            this.result = null;
            this.error = null;
            this.runtimeError = null;
        }
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                this.handleFormat((MediaFormat)message.obj);
                break;
            }
            case 1: {
                long l = Util.getLong(message.arg1, message.arg2);
                SampleHolder sampleHolder = (SampleHolder)message.obj;
                this.handleSample(l, sampleHolder);
            }
        }
        return true;
    }

    private void handleFormat(MediaFormat mediaFormat) {
        this.subtitlesAreRelative = mediaFormat.subsampleOffsetUs == Long.MAX_VALUE;
        this.subtitleOffsetUs = this.subtitlesAreRelative ? 0L : mediaFormat.subsampleOffsetUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSample(long l, SampleHolder sampleHolder) {
        Subtitle subtitle = null;
        ParserException parserException = null;
        RuntimeException runtimeException = null;
        try {
            subtitle = this.parser.parse(sampleHolder.data.array(), 0, sampleHolder.size);
        }
        catch (ParserException parserException2) {
            parserException = parserException2;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        SubtitleParserHelper subtitleParserHelper = this;
        synchronized (subtitleParserHelper) {
            if (this.sampleHolder == sampleHolder) {
                this.result = new PlayableSubtitle(subtitle, this.subtitlesAreRelative, l, this.subtitleOffsetUs);
                this.error = parserException;
                this.runtimeError = runtimeException;
                this.parsing = false;
            }
        }
    }
}

