/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.Variant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefaultHlsTrackSelector
implements HlsTrackSelector {
    private static final int TYPE_DEFAULT = 0;
    private static final int TYPE_AUDIO = 1;
    private static final int TYPE_SUBTITLE = 2;
    private final Context context;
    private final int type;

    public static DefaultHlsTrackSelector newDefaultInstance(Context context) {
        return new DefaultHlsTrackSelector(context, 0);
    }

    public static DefaultHlsTrackSelector newAudioInstance() {
        return new DefaultHlsTrackSelector(null, 1);
    }

    public static DefaultHlsTrackSelector newSubtitleInstance() {
        return new DefaultHlsTrackSelector(null, 2);
    }

    private DefaultHlsTrackSelector(Context context, int n) {
        this.context = context;
        this.type = n;
    }

    @Override
    public void selectTracks(HlsMasterPlaylist hlsMasterPlaylist, HlsTrackSelector.Output output) throws IOException {
        int n;
        if (this.type == 1 || this.type == 2) {
            List<Variant> list;
            List<Variant> list2 = list = this.type == 1 ? hlsMasterPlaylist.audios : hlsMasterPlaylist.subtitles;
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    output.fixedTrack(hlsMasterPlaylist, list.get(i));
                }
            }
            return;
        }
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        int[] nArray = VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay(this.context, hlsMasterPlaylist.variants, null, false);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(hlsMasterPlaylist.variants.get(nArray[i]));
        }
        ArrayList<Variant> arrayList2 = new ArrayList<Variant>();
        ArrayList<Variant> arrayList3 = new ArrayList<Variant>();
        for (n = 0; n < arrayList.size(); ++n) {
            Variant variant = (Variant)arrayList.get(n);
            if (variant.format.height > 0 || DefaultHlsTrackSelector.variantHasExplicitCodecWithPrefix(variant, "avc")) {
                arrayList2.add(variant);
                continue;
            }
            if (!DefaultHlsTrackSelector.variantHasExplicitCodecWithPrefix(variant, "mp4a")) continue;
            arrayList3.add(variant);
        }
        if (!arrayList2.isEmpty()) {
            arrayList = arrayList2;
        } else if (arrayList3.size() < arrayList.size()) {
            arrayList.removeAll(arrayList3);
        }
        if (arrayList.size() > 1) {
            Variant[] variantArray = new Variant[arrayList.size()];
            arrayList.toArray(variantArray);
            output.adaptiveTrack(hlsMasterPlaylist, variantArray);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            output.fixedTrack(hlsMasterPlaylist, (Variant)arrayList.get(n));
        }
    }

    private static boolean variantHasExplicitCodecWithPrefix(Variant variant, String string) {
        String string2 = variant.format.codecs;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        String[] stringArray = string2.split("(\\s*,\\s*)|(\\s*$)");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            return true;
        }
        return false;
    }
}

