/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatWrapper;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class VideoFormatSelectorUtil {
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;

    public static int[] selectVideoFormatsForDefaultDisplay(Context context, List<? extends FormatWrapper> list, String[] stringArray, boolean bl) throws MediaCodecUtil.DecoderQueryException {
        Point point = VideoFormatSelectorUtil.getViewportSize(context);
        return VideoFormatSelectorUtil.selectVideoFormats(list, stringArray, bl, true, point.x, point.y);
    }

    public static int[] selectVideoFormats(List<? extends FormatWrapper> list, String[] stringArray, boolean bl, boolean bl2, int n, int n2) throws MediaCodecUtil.DecoderQueryException {
        Format format;
        int n3;
        int n4 = Integer.MAX_VALUE;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = MediaCodecUtil.maxH264DecodableFrameSize();
        int n6 = list.size();
        for (n3 = 0; n3 < n6; ++n3) {
            format = list.get(n3).getFormat();
            if (!VideoFormatSelectorUtil.isFormatPlayable(format, stringArray, bl, n5)) continue;
            arrayList.add(n3);
            if (format.width <= 0 || format.height <= 0 || n <= 0 || n2 <= 0) continue;
            Point point = VideoFormatSelectorUtil.getMaxVideoSizeInViewport(bl2, n, n2, format.width, format.height);
            int n7 = format.width * format.height;
            if (format.width < (int)((float)point.x * 0.98f) || format.height < (int)((float)point.y * 0.98f) || n7 >= n4) continue;
            n4 = n7;
        }
        if (n4 != Integer.MAX_VALUE) {
            for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
                format = list.get(arrayList.get(n3)).getFormat();
                if (format.width <= 0 || format.height <= 0 || format.width * format.height <= n4) continue;
                arrayList.remove(n3);
            }
        }
        return Util.toArray(arrayList);
    }

    private static boolean isFormatPlayable(Format format, String[] stringArray, boolean bl, int n) throws MediaCodecUtil.DecoderQueryException {
        if (stringArray != null && !Util.contains(stringArray, format.mimeType)) {
            return false;
        }
        if (bl && (format.width >= 1280 || format.height >= 720)) {
            return false;
        }
        if (format.width > 0 && format.height > 0) {
            if (Util.SDK_INT >= 21) {
                String string = MimeTypes.getVideoMediaMimeType(format.codecs);
                if ("video/x-unknown".equals(string)) {
                    string = "video/avc";
                }
                if (format.frameRate > 0.0f) {
                    return MediaCodecUtil.isSizeAndRateSupportedV21(string, false, format.width, format.height, format.frameRate);
                }
                return MediaCodecUtil.isSizeSupportedV21(string, false, format.width, format.height);
            }
            if (format.width * format.height > n) {
                return false;
            }
        }
        return true;
    }

    private static Point getMaxVideoSizeInViewport(boolean bl, int n, int n2, int n3, int n4) {
        if (bl && n3 > n4 != n > n2) {
            int n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n3 * n2 >= n4 * n) {
            return new Point(n, Util.ceilDivide(n * n4, n3));
        }
        return new Point(Util.ceilDivide(n2 * n3, n4), n2);
    }

    private static Point getViewportSize(Context context) {
        if (Util.SDK_INT < 23 && Util.MODEL != null && Util.MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
            return new Point(3840, 2160);
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return VideoFormatSelectorUtil.getDisplaySize(windowManager.getDefaultDisplay());
    }

    private static Point getDisplaySize(Display display) {
        Point point = new Point();
        if (Util.SDK_INT >= 23) {
            VideoFormatSelectorUtil.getDisplaySizeV23(display, point);
        } else if (Util.SDK_INT >= 17) {
            VideoFormatSelectorUtil.getDisplaySizeV17(display, point);
        } else if (Util.SDK_INT >= 16) {
            VideoFormatSelectorUtil.getDisplaySizeV16(display, point);
        } else {
            VideoFormatSelectorUtil.getDisplaySizeV9(display, point);
        }
        return point;
    }

    @TargetApi(value=23)
    private static void getDisplaySizeV23(Display display, Point point) {
        Display.Mode mode = display.getMode();
        point.x = mode.getPhysicalWidth();
        point.y = mode.getPhysicalHeight();
    }

    @TargetApi(value=17)
    private static void getDisplaySizeV17(Display display, Point point) {
        display.getRealSize(point);
    }

    @TargetApi(value=16)
    private static void getDisplaySizeV16(Display display, Point point) {
        display.getSize(point);
    }

    private static void getDisplaySizeV9(Display display, Point point) {
        point.x = display.getWidth();
        point.y = display.getHeight();
    }

    private VideoFormatSelectorUtil() {
    }
}

