/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class SingleSampleMediaChunk
extends BaseMediaChunk {
    private final MediaFormat sampleFormat;
    private final DrmInitData sampleDrmInitData;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, int n, Format format, long l, long l2, int n2, MediaFormat mediaFormat, DrmInitData drmInitData, int n3) {
        super(dataSource, dataSpec, n, format, l, l2, n2, true, n3);
        this.sampleFormat = mediaFormat;
        this.sampleDrmInitData = drmInitData;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public MediaFormat getMediaFormat() {
        return this.sampleFormat;
    }

    @Override
    public DrmInitData getDrmInitData() {
        return this.sampleDrmInitData;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec dataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            this.dataSource.open(dataSpec);
            int n = 0;
            while (n != -1) {
                this.bytesLoaded += n;
                n = this.getOutput().sampleData(this.dataSource, Integer.MAX_VALUE, true);
            }
            int n2 = this.bytesLoaded;
            this.getOutput().sampleMetadata(this.startTimeUs, 1, n2, 0, null);
        }
        finally {
            this.dataSource.close();
        }
    }
}

