/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.execchain.ConnectionHolder;

@NotThreadSafe
class ResponseEntityProxy
extends HttpEntityWrapper
implements EofSensorWatcher {
    private final ConnectionHolder connHolder;

    public static void enchance(HttpResponse httpResponse, ConnectionHolder connectionHolder) {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null && httpEntity.isStreaming() && connectionHolder != null) {
            httpResponse.setEntity((HttpEntity)new ResponseEntityProxy(httpEntity, connectionHolder));
        }
    }

    ResponseEntityProxy(HttpEntity httpEntity, ConnectionHolder connectionHolder) {
        super(httpEntity);
        this.connHolder = connectionHolder;
    }

    private void cleanup() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.close();
        }
    }

    private void abortConnection() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.abortConnection();
        }
    }

    public void releaseConnection() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.releaseConnection();
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public InputStream getContent() throws IOException {
        return new EofSensorInputStream(this.wrappedEntity.getContent(), this);
    }

    @Deprecated
    public void consumeContent() throws IOException {
        this.releaseConnection();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.wrappedEntity.writeTo(outputStream);
            this.releaseConnection();
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean eofDetected(InputStream inputStream) throws IOException {
        try {
            inputStream.close();
            this.releaseConnection();
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamClosed(InputStream inputStream) throws IOException {
        try {
            boolean bl = this.connHolder != null && !this.connHolder.isReleased();
            try {
                inputStream.close();
                this.releaseConnection();
            }
            catch (SocketException socketException) {
                if (bl) {
                    throw socketException;
                }
            }
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
        finally {
            this.cleanup();
        }
        return false;
    }

    @Override
    public boolean streamAbort(InputStream inputStream) throws IOException {
        this.cleanup();
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ResponseEntityProxy{");
        stringBuilder.append(this.wrappedEntity);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

