/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@NotThreadSafe
public abstract class GGSSchemeBase
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Base64 base64codec = new Base64(0);
    private final boolean stripPort;
    private final boolean useCanonicalHostname;
    private State state;
    private byte[] token;
    private String service;

    GGSSchemeBase(boolean bl, boolean bl2) {
        this.stripPort = bl;
        this.useCanonicalHostname = bl2;
        this.state = State.UNINITIATED;
    }

    GGSSchemeBase(boolean bl) {
        this(bl, true);
    }

    GGSSchemeBase() {
        this(true, true);
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    protected byte[] generateGSSToken(byte[] byArray, Oid oid, String string) throws GSSException {
        return this.generateGSSToken(byArray, oid, string, null);
    }

    protected byte[] generateGSSToken(byte[] byArray, Oid oid, String string, Credentials credentials) throws GSSException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        GSSManager gSSManager = this.getManager();
        GSSName gSSName = gSSManager.createName(this.service + "@" + string, GSSName.NT_HOSTBASED_SERVICE);
        GSSCredential gSSCredential = credentials instanceof KerberosCredentials ? ((KerberosCredentials)credentials).getGSSCredential() : null;
        GSSContext gSSContext = gSSManager.createContext(gSSName.canonicalize(oid), oid, gSSCredential, 0);
        gSSContext.requestMutualAuth(true);
        gSSContext.requestCredDeleg(true);
        return gSSContext.initSecContext(byArray2, 0, byArray2.length);
    }

    @Deprecated
    protected byte[] generateToken(byte[] byArray, String string) throws GSSException {
        return null;
    }

    protected byte[] generateToken(byte[] byArray, String string, Credentials credentials) throws GSSException {
        return this.generateToken(byArray, string);
    }

    @Override
    public boolean isComplete() {
        return this.state == State.TOKEN_GENERATED || this.state == State.FAILED;
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest, null);
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        switch (this.state) {
            case UNINITIATED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has not been initiated");
            }
            case FAILED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                HttpHost httpHost;
                Object object;
                try {
                    object = (HttpRoute)httpContext.getAttribute("http.route");
                    if (object == null) {
                        throw new AuthenticationException("Connection route is not available");
                    }
                    if (this.isProxy()) {
                        httpHost = ((HttpRoute)object).getProxyHost();
                        if (httpHost == null) {
                            httpHost = ((HttpRoute)object).getTargetHost();
                        }
                    } else {
                        httpHost = ((HttpRoute)object).getTargetHost();
                    }
                    String string = httpHost.getHostName();
                    if (this.useCanonicalHostname) {
                        try {
                            string = this.resolveCanonicalHostname(string);
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    String string2 = this.stripPort ? string : string + ":" + httpHost.getPort();
                    this.service = httpHost.getSchemeName().toUpperCase(Locale.ROOT);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("init " + string2));
                    }
                    this.token = this.generateToken(this.token, string2, credentials);
                    this.state = State.TOKEN_GENERATED;
                }
                catch (GSSException gSSException) {
                    this.state = State.FAILED;
                    if (gSSException.getMajor() == 9 || gSSException.getMajor() == 8) {
                        throw new InvalidCredentialsException(gSSException.getMessage(), gSSException);
                    }
                    if (gSSException.getMajor() == 13) {
                        throw new InvalidCredentialsException(gSSException.getMessage(), gSSException);
                    }
                    if (gSSException.getMajor() == 10 || gSSException.getMajor() == 19 || gSSException.getMajor() == 20) {
                        throw new AuthenticationException(gSSException.getMessage(), gSSException);
                    }
                    throw new AuthenticationException(gSSException.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                Object object = new String(this.base64codec.encode(this.token));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending response '" + (String)object + "' back to the auth server"));
                }
                HttpHost httpHost = new CharArrayBuffer(32);
                if (this.isProxy()) {
                    httpHost.append("Proxy-Authorization");
                } else {
                    httpHost.append("Authorization");
                }
                httpHost.append(": Negotiate ");
                httpHost.append((String)object);
                return new BufferedHeader((CharArrayBuffer)httpHost);
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.state));
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n, int n2) throws MalformedChallengeException {
        String string = charArrayBuffer.substringTrimmed(n, n2);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received challenge '" + string + "' from the auth server"));
        }
        if (this.state == State.UNINITIATED) {
            this.token = Base64.decodeBase64((byte[])string.getBytes());
            this.state = State.CHALLENGE_RECEIVED;
        } else {
            this.log.debug((Object)"Authentication already attempted");
            this.state = State.FAILED;
        }
    }

    private String resolveCanonicalHostname(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = inetAddress.getCanonicalHostName();
        if (inetAddress.getHostAddress().contentEquals(string2)) {
            return string;
        }
        return string2;
    }

    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

