/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.annotation.TargetApi;
import android.media.MediaDrm;
import android.text.TextUtils;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerUtil;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;

@TargetApi(value=18)
public class WidevineTestMediaDrmCallback
implements MediaDrmCallback {
    private static final String WIDEVINE_GTS_DEFAULT_BASE_URI = "http://wv-staging-proxy.appspot.com/proxy?provider=YouTube&video_id=";
    private final String defaultUri;

    public WidevineTestMediaDrmCallback(String string) {
        this.defaultUri = WIDEVINE_GTS_DEFAULT_BASE_URI + string;
    }

    @Override
    public byte[] executeProvisionRequest(UUID uUID, MediaDrm.ProvisionRequest provisionRequest) throws ClientProtocolException, IOException {
        String string = provisionRequest.getDefaultUrl() + "&signedRequest=" + new String(provisionRequest.getData());
        return ExoplayerUtil.executePost(string, null, null);
    }

    @Override
    public byte[] executeKeyRequest(UUID uUID, MediaDrm.KeyRequest keyRequest) throws IOException {
        String string = keyRequest.getDefaultUrl();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.defaultUri;
        }
        return ExoplayerUtil.executePost(string, keyRequest.getData(), null);
    }
}

