/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.util.Assertions;

public final class ParsableBitArray {
    public byte[] data;
    private int byteOffset;
    private int bitOffset;
    private int byteLimit;

    public ParsableBitArray() {
    }

    public ParsableBitArray(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public ParsableBitArray(byte[] byArray, int n) {
        this.data = byArray;
        this.byteLimit = n;
    }

    public void reset(byte[] byArray) {
        this.reset(byArray, byArray.length);
    }

    public void reset(byte[] byArray, int n) {
        this.data = byArray;
        this.byteOffset = 0;
        this.bitOffset = 0;
        this.byteLimit = n;
    }

    public int bitsLeft() {
        return (this.byteLimit - this.byteOffset) * 8 - this.bitOffset;
    }

    public int getPosition() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public void setPosition(int n) {
        this.byteOffset = n / 8;
        this.bitOffset = n - this.byteOffset * 8;
        this.assertValidOffset();
    }

    public void skipBits(int n) {
        this.byteOffset += n / 8;
        this.bitOffset += n % 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
        this.assertValidOffset();
    }

    public boolean readBit() {
        return this.readBits(1) == 1;
    }

    public int readBits(int n) {
        int n2;
        int n3;
        if (n == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = n / 8;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = this.bitOffset != 0 ? (this.data[this.byteOffset] & 0xFF) << this.bitOffset | (this.data[this.byteOffset + 1] & 0xFF) >>> 8 - this.bitOffset : this.data[this.byteOffset];
            n4 |= (n2 & 0xFF) << (n -= 8);
            ++this.byteOffset;
        }
        if (n > 0) {
            n3 = this.bitOffset + n;
            n2 = (byte)(255 >> 8 - n);
            if (n3 > 8) {
                n4 |= ((this.data[this.byteOffset] & 0xFF) << n3 - 8 | (this.data[this.byteOffset + 1] & 0xFF) >> 16 - n3) & n2;
                ++this.byteOffset;
            } else {
                n4 |= (this.data[this.byteOffset] & 0xFF) >> 8 - n3 & n2;
                if (n3 == 8) {
                    ++this.byteOffset;
                }
            }
            this.bitOffset = n3 % 8;
        }
        this.assertValidOffset();
        return n4;
    }

    public boolean canReadExpGolombCodedNum() {
        int n = this.byteOffset;
        int n2 = this.bitOffset;
        int n3 = 0;
        while (this.byteOffset < this.byteLimit && !this.readBit()) {
            ++n3;
        }
        boolean bl = this.byteOffset == this.byteLimit;
        this.byteOffset = n;
        this.bitOffset = n2;
        return !bl && this.bitsLeft() >= n3 * 2 + 1;
    }

    public int readUnsignedExpGolombCodedInt() {
        return this.readExpGolombCodeNum();
    }

    public int readSignedExpGolombCodedInt() {
        int n = this.readExpGolombCodeNum();
        return (n % 2 == 0 ? -1 : 1) * ((n + 1) / 2);
    }

    private int readExpGolombCodeNum() {
        int n = 0;
        while (!this.readBit()) {
            ++n;
        }
        return (1 << n) - 1 + (n > 0 ? this.readBits(n) : 0);
    }

    private void assertValidOffset() {
        Assertions.checkState(this.byteOffset >= 0 && this.bitOffset >= 0 && this.bitOffset < 8 && (this.byteOffset < this.byteLimit || this.byteOffset == this.byteLimit && this.bitOffset == 0));
    }
}

