/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.util.Pair;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableBitArray;
import java.util.ArrayList;

public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final int AUDIO_SPECIFIC_CONFIG_FREQUENCY_INDEX_ARBITRARY = 15;
    private static final int[] AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    private static final int AUDIO_SPECIFIC_CONFIG_CHANNEL_CONFIGURATION_INVALID = -1;
    private static final int[] AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 8, -1, -1, -1, 7, 8, -1, 8, -1};
    private static final int AUDIO_OBJECT_TYPE_AAC_LC = 2;
    private static final int AUDIO_OBJECT_TYPE_SBR = 5;
    private static final int AUDIO_OBJECT_TYPE_ER_BSAC = 22;
    private static final int AUDIO_OBJECT_TYPE_PS = 29;

    private CodecSpecificDataUtil() {
    }

    public static Pair<Integer, Integer> parseAacAudioSpecificConfig(byte[] byArray) {
        int n;
        int n2;
        ParsableBitArray parsableBitArray = new ParsableBitArray(byArray);
        int n3 = parsableBitArray.readBits(5);
        int n4 = parsableBitArray.readBits(4);
        if (n4 == 15) {
            n2 = parsableBitArray.readBits(24);
        } else {
            Assertions.checkArgument(n4 < 13);
            n2 = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[n4];
        }
        int n5 = parsableBitArray.readBits(4);
        if (n3 == 5 || n3 == 29) {
            n4 = parsableBitArray.readBits(4);
            if (n4 == 15) {
                n2 = parsableBitArray.readBits(24);
            } else {
                Assertions.checkArgument(n4 < 13);
                n2 = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[n4];
            }
            n3 = parsableBitArray.readBits(5);
            if (n3 == 22) {
                n5 = parsableBitArray.readBits(4);
            }
        }
        Assertions.checkArgument((n = AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[n5]) != -1);
        return Pair.create((Object)n2, (Object)n);
    }

    public static byte[] buildAacAudioSpecificConfig(int n, int n2, int n3) {
        byte[] byArray = new byte[]{(byte)(n << 3 & 0xF8 | n2 >> 1 & 7), (byte)(n2 << 7 & 0x80 | n3 << 3 & 0x78)};
        return byArray;
    }

    public static byte[] buildAacAudioSpecificConfig(int n, int n2) {
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE.length; ++n3) {
            if (n != AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[n3]) continue;
            n4 = n3;
        }
        n3 = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE.length; ++i) {
            if (n2 != AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[i]) continue;
            n3 = i;
        }
        byte[] byArray = new byte[]{(byte)(0x10 | n4 >> 1), (byte)((n4 & 1) << 7 | n3 << 3)};
        return byArray;
    }

    public static byte[] buildNalUnit(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, byArray2, 0, NAL_START_CODE.length);
        System.arraycopy(byArray, n, byArray2, NAL_START_CODE.length, n2);
        return byArray2;
    }

    public static byte[][] splitNalUnits(byte[] byArray) {
        if (!CodecSpecificDataUtil.isNalStartCode(byArray, 0)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        do {
            arrayList.add(n);
        } while ((n = CodecSpecificDataUtil.findNalStartCode(byArray, n + NAL_START_CODE.length)) != -1);
        byte[][] byArrayArray = new byte[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2 = (Integer)arrayList.get(i);
            int n3 = i < arrayList.size() - 1 ? (Integer)arrayList.get(i + 1) : byArray.length;
            byte[] byArray2 = new byte[n3 - n2];
            System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
            byArrayArray[i] = byArray2;
        }
        return byArrayArray;
    }

    private static int findNalStartCode(byte[] byArray, int n) {
        int n2 = byArray.length - NAL_START_CODE.length;
        for (int i = n; i <= n2; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(byArray, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] byArray, int n) {
        if (byArray.length - n <= NAL_START_CODE.length) {
            return false;
        }
        for (int i = 0; i < NAL_START_CODE.length; ++i) {
            if (byArray[n + i] == NAL_START_CODE[i]) continue;
            return false;
        }
        return true;
    }
}

