/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.net.Uri;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.upstream.DataSourceInputStream;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.IOException;
import java.io.InputStream;

public final class UriLoadable<T>
implements Loader.Loadable {
    private final DataSpec dataSpec;
    private final UriDataSource uriDataSource;
    private final Parser<T> parser;
    private volatile T result;
    private volatile boolean isCanceled;

    public UriLoadable(String string, UriDataSource uriDataSource, Parser<T> parser) {
        this.uriDataSource = uriDataSource;
        this.parser = parser;
        this.dataSpec = new DataSpec(Uri.parse((String)string), 1);
    }

    public final T getResult() {
        return this.result;
    }

    @Override
    public final void cancelLoad() {
        this.isCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.isCanceled;
    }

    @Override
    public final void load() throws IOException, InterruptedException {
        try (DataSourceInputStream dataSourceInputStream = new DataSourceInputStream(this.uriDataSource, this.dataSpec);){
            dataSourceInputStream.open();
            this.result = this.parser.parse(this.uriDataSource.getUri(), dataSourceInputStream);
        }
    }

    public static interface Parser<T> {
        public T parse(String var1, InputStream var2) throws ParserException, IOException;
    }
}

