/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Arrays;

public final class DefaultAllocator
implements Allocator {
    private static final int AVAILABLE_EXTRA_CAPACITY = 100;
    private final int individualAllocationSize;
    private final byte[] initialAllocationBlock;
    private int allocatedCount;
    private int availableCount;
    private Allocation[] availableAllocations;

    public DefaultAllocator(int n) {
        this(n, 0);
    }

    public DefaultAllocator(int n, int n2) {
        Assertions.checkArgument(n > 0);
        Assertions.checkArgument(n2 >= 0);
        this.individualAllocationSize = n;
        this.availableCount = n2;
        this.availableAllocations = new Allocation[n2 + 100];
        if (n2 > 0) {
            this.initialAllocationBlock = new byte[n2 * n];
            for (int i = 0; i < n2; ++i) {
                int n3 = i * n;
                this.availableAllocations[i] = new Allocation(this.initialAllocationBlock, n3);
            }
        } else {
            this.initialAllocationBlock = null;
        }
    }

    @Override
    public synchronized Allocation allocate() {
        Allocation allocation;
        ++this.allocatedCount;
        if (this.availableCount > 0) {
            allocation = this.availableAllocations[--this.availableCount];
            this.availableAllocations[this.availableCount] = null;
        } else {
            allocation = new Allocation(new byte[this.individualAllocationSize], 0);
        }
        return allocation;
    }

    @Override
    public synchronized void release(Allocation allocation) {
        Assertions.checkArgument(allocation.data == this.initialAllocationBlock || allocation.data.length == this.individualAllocationSize);
        --this.allocatedCount;
        if (this.availableCount == this.availableAllocations.length) {
            this.availableAllocations = Arrays.copyOf(this.availableAllocations, this.availableAllocations.length * 2);
        }
        this.availableAllocations[this.availableCount++] = allocation;
        this.notifyAll();
    }

    @Override
    public synchronized void trim(int n) {
        int n2 = Util.ceilDivide(n, this.individualAllocationSize);
        int n3 = Math.max(0, n2 - this.allocatedCount);
        if (n3 >= this.availableCount) {
            return;
        }
        if (this.initialAllocationBlock != null) {
            int n4 = 0;
            int n5 = this.availableCount - 1;
            while (n4 <= n5) {
                Allocation allocation = this.availableAllocations[n4];
                if (allocation.data == this.initialAllocationBlock) {
                    ++n4;
                    continue;
                }
                Allocation allocation2 = this.availableAllocations[n4];
                if (allocation2.data != this.initialAllocationBlock) {
                    --n5;
                    continue;
                }
                this.availableAllocations[n4++] = allocation2;
                this.availableAllocations[n5--] = allocation;
            }
            if ((n3 = Math.max(n3, n4)) >= this.availableCount) {
                return;
            }
        }
        Arrays.fill(this.availableAllocations, n3, this.availableCount, null);
        this.availableCount = n3;
    }

    @Override
    public synchronized int getTotalBytesAllocated() {
        return this.allocatedCount * this.individualAllocationSize;
    }

    @Override
    public synchronized void blockWhileTotalBytesAllocatedExceeds(int n) throws InterruptedException {
        while (this.getTotalBytesAllocated() > n) {
            this.wait();
        }
    }

    @Override
    public int getIndividualAllocationLength() {
        return this.individualAllocationSize;
    }
}

