/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentDataSource
implements UriDataSource {
    private final ContentResolver resolver;
    private final TransferListener listener;
    private InputStream inputStream;
    private String uriString;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        this(context, null);
    }

    public ContentDataSource(Context context, TransferListener transferListener) {
        this.resolver = context.getContentResolver();
        this.listener = transferListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            AssetFileDescriptor assetFileDescriptor = this.resolver.openAssetFileDescriptor(dataSpec.uri, "r");
            this.inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
            long l = this.inputStream.skip(dataSpec.position);
            if (l < dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == 0L) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (IOException iOException) {
            throw new ContentDataSourceException(iOException);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws ContentDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n3 = 0;
        try {
            int n4 = this.bytesRemaining == -1L ? n2 : (int)Math.min(this.bytesRemaining, (long)n2);
            n3 = this.inputStream.read(byArray, n, n4);
        }
        catch (IOException iOException) {
            throw new ContentDataSourceException(iOException);
        }
        if (n3 > 0) {
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)n3;
            }
            if (this.listener != null) {
                this.listener.onBytesTransferred(n3);
            }
        }
        return n3;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    @Override
    public void close() throws ContentDataSourceException {
        this.uriString = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                throw new ContentDataSourceException(iOException);
            }
            finally {
                this.inputStream = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static class ContentDataSourceException
    extends IOException {
        public ContentDataSourceException(IOException iOException) {
            super(iOException);
        }
    }
}

