/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.webvtt.Mp4WebvttSubtitle;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;

public final class Mp4WebvttParser
implements SubtitleParser {
    private static final int BOX_HEADER_SIZE = 8;
    private static final int TYPE_payl = Util.getIntegerCodeForString("payl");
    private static final int TYPE_sttg = Util.getIntegerCodeForString("sttg");
    private static final int TYPE_vttc = Util.getIntegerCodeForString("vttc");
    private final ParsableByteArray sampleData = new ParsableByteArray();
    private final WebvttCue.Builder builder = new WebvttCue.Builder();

    @Override
    public boolean canParse(String string) {
        return "application/x-mp4vtt".equals(string);
    }

    @Override
    public Mp4WebvttSubtitle parse(byte[] byArray, int n, int n2) throws ParserException {
        this.sampleData.reset(byArray, n + n2);
        this.sampleData.setPosition(n);
        ArrayList<Cue> arrayList = new ArrayList<Cue>();
        while (this.sampleData.bytesLeft() > 0) {
            if (this.sampleData.bytesLeft() < 8) {
                throw new ParserException("Incomplete Mp4Webvtt Top Level box header found.");
            }
            int n3 = this.sampleData.readInt();
            int n4 = this.sampleData.readInt();
            if (n4 == TYPE_vttc) {
                arrayList.add(Mp4WebvttParser.parseVttCueBox(this.sampleData, this.builder, n3 - 8));
                continue;
            }
            this.sampleData.skipBytes(n3 - 8);
        }
        return new Mp4WebvttSubtitle(arrayList);
    }

    private static Cue parseVttCueBox(ParsableByteArray parsableByteArray, WebvttCue.Builder builder, int n) throws ParserException {
        builder.reset();
        while (n > 0) {
            if (n < 8) {
                throw new ParserException("Incomplete vtt cue box header found.");
            }
            int n2 = parsableByteArray.readInt();
            int n3 = parsableByteArray.readInt();
            n -= 8;
            int n4 = n2 - 8;
            String string = new String(parsableByteArray.data, parsableByteArray.getPosition(), n4);
            parsableByteArray.skipBytes(n4);
            n -= n4;
            if (n3 == TYPE_sttg) {
                WebvttCueParser.parseCueSettingsList(string, builder);
                continue;
            }
            if (n3 != TYPE_payl) continue;
            WebvttCueParser.parseCueText(string.trim(), builder);
        }
        return builder.build();
    }
}

