/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.ttml.TtmlNode;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import com.google.android.exoplayer.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TtmlSubtitle
implements Subtitle {
    private final TtmlNode root;
    private final long[] eventTimesUs;
    private final Map<String, TtmlStyle> globalStyles;

    public TtmlSubtitle(TtmlNode ttmlNode, Map<String, TtmlStyle> map) {
        this.root = ttmlNode;
        this.globalStyles = map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
        this.eventTimesUs = ttmlNode.getEventTimesUs();
    }

    @Override
    public int getNextEventTimeIndex(long l) {
        int n = Util.binarySearchCeil(this.eventTimesUs, l, false, false);
        return n < this.eventTimesUs.length ? n : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.eventTimesUs.length;
    }

    @Override
    public long getEventTime(int n) {
        return this.eventTimesUs[n];
    }

    @Override
    public long getLastEventTime() {
        return this.eventTimesUs.length == 0 ? -1L : this.eventTimesUs[this.eventTimesUs.length - 1];
    }

    TtmlNode getRoot() {
        return this.root;
    }

    @Override
    public List<Cue> getCues(long l) {
        CharSequence charSequence = this.root.getText(l, this.globalStyles);
        if (charSequence == null) {
            return Collections.emptyList();
        }
        Cue cue = new Cue(charSequence);
        return Collections.singletonList(cue);
    }

    Map<String, TtmlStyle> getGlobalStyles() {
        return this.globalStyles;
    }
}

