/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.SampleSourceTrackRenderer;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.PlayableSubtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.SubtitleParserHelper;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TargetApi(value=16)
public final class TextTrackRenderer
extends SampleSourceTrackRenderer
implements Handler.Callback {
    private static final int MSG_UPDATE_OVERLAY = 0;
    private static final List<Class<? extends SubtitleParser>> DEFAULT_PARSER_CLASSES = new ArrayList<Class<? extends SubtitleParser>>();
    private final Handler textRendererHandler;
    private final TextRenderer textRenderer;
    private final MediaFormatHolder formatHolder;
    private final SubtitleParser[] subtitleParsers;
    private int parserIndex;
    private boolean inputStreamEnded;
    private PlayableSubtitle subtitle;
    private PlayableSubtitle nextSubtitle;
    private SubtitleParserHelper parserHelper;
    private HandlerThread parserThread;
    private int nextSubtitleEventIndex;

    public TextTrackRenderer(SampleSource sampleSource, TextRenderer textRenderer, Looper looper, SubtitleParser ... subtitleParserArray) {
        this(new SampleSource[]{sampleSource}, textRenderer, looper, subtitleParserArray);
    }

    public TextTrackRenderer(SampleSource[] sampleSourceArray, TextRenderer textRenderer, Looper looper, SubtitleParser ... subtitleParserArray) {
        super(sampleSourceArray);
        this.textRenderer = Assertions.checkNotNull(textRenderer);
        Handler handler = this.textRendererHandler = looper == null ? null : new Handler(looper, (Handler.Callback)this);
        if (subtitleParserArray == null || subtitleParserArray.length == 0) {
            subtitleParserArray = new SubtitleParser[DEFAULT_PARSER_CLASSES.size()];
            for (int i = 0; i < subtitleParserArray.length; ++i) {
                try {
                    subtitleParserArray[i] = DEFAULT_PARSER_CLASSES.get(i).newInstance();
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Unexpected error creating default parser", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Unexpected error creating default parser", illegalAccessException);
                }
            }
        }
        this.subtitleParsers = subtitleParserArray;
        this.formatHolder = new MediaFormatHolder();
    }

    @Override
    protected boolean handlesTrack(MediaFormat mediaFormat) {
        return this.getParserIndex(mediaFormat) != -1;
    }

    @Override
    protected void onEnabled(int n, long l, boolean bl) throws ExoPlaybackException {
        super.onEnabled(n, l, bl);
        this.parserIndex = this.getParserIndex(this.getFormat(n));
        this.parserThread = new HandlerThread("textParser");
        this.parserThread.start();
        this.parserHelper = new SubtitleParserHelper(this.parserThread.getLooper(), this.subtitleParsers[this.parserIndex]);
    }

    @Override
    protected void onDiscontinuity(long l) {
        this.inputStreamEnded = false;
        this.subtitle = null;
        this.nextSubtitle = null;
        this.clearTextRenderer();
        if (this.parserHelper != null) {
            this.parserHelper.flush();
        }
    }

    @Override
    protected void doSomeWork(long l, long l2, boolean bl) throws ExoPlaybackException {
        if (this.nextSubtitle == null) {
            try {
                this.nextSubtitle = this.parserHelper.getAndClearResult();
            }
            catch (IOException iOException) {
                throw new ExoPlaybackException(iOException);
            }
        }
        if (this.getState() != 3) {
            return;
        }
        boolean bl2 = false;
        long l3 = Long.MAX_VALUE;
        if (this.subtitle != null) {
            l3 = this.getNextEventTime();
            while (l3 <= l) {
                ++this.nextSubtitleEventIndex;
                l3 = this.getNextEventTime();
                bl2 = true;
            }
        }
        if (this.nextSubtitle != null && this.nextSubtitle.startTimeUs <= l) {
            this.subtitle = this.nextSubtitle;
            this.nextSubtitle = null;
            this.nextSubtitleEventIndex = this.subtitle.getNextEventTimeIndex(l);
            bl2 = true;
        }
        if (bl2) {
            this.updateTextRenderer(this.subtitle.getCues(l));
        }
        if (!this.inputStreamEnded && this.nextSubtitle == null && !this.parserHelper.isParsing()) {
            SampleHolder sampleHolder = this.parserHelper.getSampleHolder();
            sampleHolder.clearData();
            int n = this.readSource(l, this.formatHolder, sampleHolder);
            if (n == -4) {
                this.parserHelper.setFormat(this.formatHolder.format);
            } else if (n == -3) {
                this.parserHelper.startParseOperation();
            } else if (n == -1) {
                this.inputStreamEnded = true;
            }
        }
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.subtitle = null;
        this.nextSubtitle = null;
        this.parserThread.quit();
        this.parserThread = null;
        this.parserHelper = null;
        this.clearTextRenderer();
        super.onDisabled();
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded && (this.subtitle == null || this.getNextEventTime() == Long.MAX_VALUE);
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private long getNextEventTime() {
        return this.nextSubtitleEventIndex == -1 || this.nextSubtitleEventIndex >= this.subtitle.getEventTimeCount() ? Long.MAX_VALUE : this.subtitle.getEventTime(this.nextSubtitleEventIndex);
    }

    private void updateTextRenderer(List<Cue> list) {
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, list).sendToTarget();
        } else {
            this.invokeRendererInternalCues(list);
        }
    }

    private void clearTextRenderer() {
        this.updateTextRenderer(Collections.emptyList());
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                this.invokeRendererInternalCues((List)message.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternalCues(List<Cue> list) {
        this.textRenderer.onCues(list);
    }

    private int getParserIndex(MediaFormat mediaFormat) {
        for (int i = 0; i < this.subtitleParsers.length; ++i) {
            if (!this.subtitleParsers[i].canParse(mediaFormat.mimeType)) continue;
            return i;
        }
        return -1;
    }

    static {
        try {
            DEFAULT_PARSER_CLASSES.add(Class.forName("com.google.android.exoplayer.text.webvtt.WebvttParser").asSubclass(SubtitleParser.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_PARSER_CLASSES.add(Class.forName("com.google.android.exoplayer.text.ttml.TtmlParser").asSubclass(SubtitleParser.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_PARSER_CLASSES.add(Class.forName("com.google.android.exoplayer.text.webvtt.Mp4WebvttParser").asSubclass(SubtitleParser.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_PARSER_CLASSES.add(Class.forName("com.google.android.exoplayer.text.subrip.SubripParser").asSubclass(SubtitleParser.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_PARSER_CLASSES.add(Class.forName("com.google.android.exoplayer.text.tx3g.Tx3gParser").asSubclass(SubtitleParser.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

