/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.text.TextUtils;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.PtsTimestampAdjuster;
import com.google.android.exoplayer.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class WebvttExtractor
implements Extractor {
    private static final Pattern LOCAL_TIMESTAMP = Pattern.compile("LOCAL:([^,]+)");
    private static final Pattern MEDIA_TIMESTAMP = Pattern.compile("MPEGTS:(\\d+)");
    private final PtsTimestampAdjuster ptsTimestampAdjuster;
    private final ParsableByteArray sampleDataWrapper;
    private ExtractorOutput output;
    private byte[] sampleData;
    private int sampleSize;

    public WebvttExtractor(PtsTimestampAdjuster ptsTimestampAdjuster) {
        this.ptsTimestampAdjuster = ptsTimestampAdjuster;
        this.sampleDataWrapper = new ParsableByteArray();
        this.sampleData = new byte[1024];
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        throw new IllegalStateException();
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
        extractorOutput.seekMap(SeekMap.UNSEEKABLE);
    }

    @Override
    public void seek() {
        throw new IllegalStateException();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        int n;
        int n2 = (int)extractorInput.getLength();
        if (this.sampleSize == this.sampleData.length) {
            this.sampleData = Arrays.copyOf(this.sampleData, (n2 != -1 ? n2 : this.sampleData.length) * 3 / 2);
        }
        if ((n = extractorInput.read(this.sampleData, this.sampleSize, this.sampleData.length - this.sampleSize)) != -1) {
            this.sampleSize += n;
            if (n2 == -1 || this.sampleSize != n2) {
                return 0;
            }
        }
        this.processSample();
        return -1;
    }

    private void processSample() throws ParserException {
        Matcher matcher;
        String string;
        ParsableByteArray parsableByteArray = new ParsableByteArray(this.sampleData);
        WebvttParserUtil.validateWebvttHeaderLine(parsableByteArray);
        long l = 0L;
        long l2 = 0L;
        while (!TextUtils.isEmpty((CharSequence)(string = parsableByteArray.readLine()))) {
            if (!string.startsWith("X-TIMESTAMP-MAP")) continue;
            matcher = LOCAL_TIMESTAMP.matcher(string);
            if (!matcher.find()) {
                throw new ParserException("X-TIMESTAMP-MAP doesn't contain local timestamp: " + string);
            }
            Matcher matcher2 = MEDIA_TIMESTAMP.matcher(string);
            if (!matcher2.find()) {
                throw new ParserException("X-TIMESTAMP-MAP doesn't contain media timestamp: " + string);
            }
            l = WebvttParserUtil.parseTimestampUs(matcher.group(1));
            l2 = PtsTimestampAdjuster.ptsToUs(Long.parseLong(matcher2.group(1)));
        }
        matcher = WebvttCueParser.findNextCueHeader(parsableByteArray);
        if (matcher == null) {
            this.buildTrackOutput(0L);
            return;
        }
        long l3 = WebvttParserUtil.parseTimestampUs(matcher.group(1));
        long l4 = this.ptsTimestampAdjuster.adjustTimestamp(PtsTimestampAdjuster.usToPts(l3 + l2 - l));
        long l5 = l4 - l3;
        TrackOutput trackOutput = this.buildTrackOutput(l5);
        this.sampleDataWrapper.reset(this.sampleData, this.sampleSize);
        trackOutput.sampleData(this.sampleDataWrapper, this.sampleSize);
        trackOutput.sampleMetadata(l4, 1, this.sampleSize, 0, null);
    }

    private TrackOutput buildTrackOutput(long l) {
        TrackOutput trackOutput = this.output.track(0);
        trackOutput.format(MediaFormat.createTextFormat("id", "text/vtt", -1, -1L, "en", l));
        this.output.endTracks();
        return trackOutput;
    }
}

