/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.hls.Aes128DataSource;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class TsChunk
extends MediaChunk {
    public final int discontinuitySequenceNumber;
    public final HlsExtractorWrapper extractorWrapper;
    private final boolean isEncrypted;
    private int bytesLoaded;
    private volatile boolean loadCanceled;

    public TsChunk(DataSource dataSource, DataSpec dataSpec, int n, Format format, long l, long l2, int n2, int n3, HlsExtractorWrapper hlsExtractorWrapper, byte[] byArray, byte[] byArray2) {
        super(TsChunk.buildDataSource(dataSource, byArray, byArray2), dataSpec, n, format, l, l2, n2);
        this.discontinuitySequenceNumber = n3;
        this.extractorWrapper = hlsExtractorWrapper;
        this.isEncrypted = this.dataSource instanceof Aes128DataSource;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        boolean bl;
        DataSpec dataSpec;
        if (this.isEncrypted) {
            dataSpec = this.dataSpec;
            bl = this.bytesLoaded != 0;
        } else {
            dataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
            bl = false;
        }
        try {
            DefaultExtractorInput defaultExtractorInput = new DefaultExtractorInput(this.dataSource, dataSpec.absoluteStreamPosition, this.dataSource.open(dataSpec));
            if (bl) {
                defaultExtractorInput.skipFully(this.bytesLoaded);
            }
            try {
                int n = 0;
                while (n == 0 && !this.loadCanceled) {
                    n = this.extractorWrapper.read(defaultExtractorInput);
                }
            }
            finally {
                this.bytesLoaded = (int)(defaultExtractorInput.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return dataSource;
        }
        return new Aes128DataSource(dataSource, byArray, byArray2);
    }
}

