/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.ParserException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HlsParserUtil {
    private static final String BOOLEAN_YES = "YES";
    private static final String BOOLEAN_NO = "NO";

    private HlsParserUtil() {
    }

    public static String parseStringAttr(String string, Pattern pattern, String string2) throws ParserException {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new ParserException("Couldn't match " + string2 + " tag in " + string);
    }

    public static int parseIntAttr(String string, Pattern pattern, String string2) throws ParserException {
        return Integer.parseInt(HlsParserUtil.parseStringAttr(string, pattern, string2));
    }

    public static double parseDoubleAttr(String string, Pattern pattern, String string2) throws ParserException {
        return Double.parseDouble(HlsParserUtil.parseStringAttr(string, pattern, string2));
    }

    public static String parseOptionalStringAttr(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean parseOptionalBooleanAttr(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return BOOLEAN_YES.equals(matcher.group(1));
        }
        return false;
    }

    public static Pattern compileBooleanAttrPattern(String string) {
        return Pattern.compile(string + "=(" + BOOLEAN_YES + "|" + BOOLEAN_NO + ")");
    }
}

