/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import java.io.IOException;

public final class HlsExtractorWrapper
implements ExtractorOutput {
    public final int trigger;
    public final Format format;
    public final long startTimeUs;
    private final Extractor extractor;
    private final SparseArray<DefaultTrackOutput> sampleQueues;
    private final boolean shouldSpliceIn;
    private final int adaptiveMaxWidth;
    private final int adaptiveMaxHeight;
    private MediaFormat[] sampleQueueFormats;
    private Allocator allocator;
    private volatile boolean tracksBuilt;
    private boolean prepared;
    private boolean spliceConfigured;

    public HlsExtractorWrapper(int n, Format format, long l, Extractor extractor, boolean bl, int n2, int n3) {
        this.trigger = n;
        this.format = format;
        this.startTimeUs = l;
        this.extractor = extractor;
        this.shouldSpliceIn = bl;
        this.adaptiveMaxWidth = n2;
        this.adaptiveMaxHeight = n3;
        this.sampleQueues = new SparseArray();
    }

    public void init(Allocator allocator) {
        this.allocator = allocator;
        this.extractor.init(this);
    }

    public boolean isPrepared() {
        if (!this.prepared && this.tracksBuilt) {
            int n;
            for (n = 0; n < this.sampleQueues.size(); ++n) {
                if (((DefaultTrackOutput)this.sampleQueues.valueAt(n)).hasFormat()) continue;
                return false;
            }
            this.prepared = true;
            this.sampleQueueFormats = new MediaFormat[this.sampleQueues.size()];
            for (n = 0; n < this.sampleQueueFormats.length; ++n) {
                MediaFormat mediaFormat = ((DefaultTrackOutput)this.sampleQueues.valueAt(n)).getFormat();
                if (MimeTypes.isVideo(mediaFormat.mimeType) && (this.adaptiveMaxWidth != -1 || this.adaptiveMaxHeight != -1)) {
                    mediaFormat = mediaFormat.copyWithMaxVideoDimensions(this.adaptiveMaxWidth, this.adaptiveMaxHeight);
                }
                this.sampleQueueFormats[n] = mediaFormat;
            }
        }
        return this.prepared;
    }

    public void clear() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).clear();
        }
    }

    public long getLargestParsedTimestampUs() {
        long l = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            l = Math.max(l, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestParsedTimestampUs());
        }
        return l;
    }

    public final void configureSpliceTo(HlsExtractorWrapper hlsExtractorWrapper) {
        Assertions.checkState(this.isPrepared());
        if (this.spliceConfigured || !hlsExtractorWrapper.shouldSpliceIn || !hlsExtractorWrapper.isPrepared()) {
            return;
        }
        boolean bl = true;
        int n = this.getTrackCount();
        for (int i = 0; i < n; ++i) {
            DefaultTrackOutput defaultTrackOutput = (DefaultTrackOutput)this.sampleQueues.valueAt(i);
            DefaultTrackOutput defaultTrackOutput2 = (DefaultTrackOutput)hlsExtractorWrapper.sampleQueues.valueAt(i);
            bl &= defaultTrackOutput.configureSpliceTo(defaultTrackOutput2);
        }
        this.spliceConfigured = bl;
    }

    public int getTrackCount() {
        Assertions.checkState(this.isPrepared());
        return this.sampleQueues.size();
    }

    public MediaFormat getMediaFormat(int n) {
        Assertions.checkState(this.isPrepared());
        return this.sampleQueueFormats[n];
    }

    public boolean getSample(int n, SampleHolder sampleHolder) {
        Assertions.checkState(this.isPrepared());
        return ((DefaultTrackOutput)this.sampleQueues.valueAt(n)).getSample(sampleHolder);
    }

    public void discardUntil(int n, long l) {
        Assertions.checkState(this.isPrepared());
        ((DefaultTrackOutput)this.sampleQueues.valueAt(n)).discardUntil(l);
    }

    public boolean hasSamples(int n) {
        Assertions.checkState(this.isPrepared());
        return !((DefaultTrackOutput)this.sampleQueues.valueAt(n)).isEmpty();
    }

    public int read(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n = this.extractor.read(extractorInput, null);
        Assertions.checkState(n != 1);
        return n;
    }

    @Override
    public TrackOutput track(int n) {
        DefaultTrackOutput defaultTrackOutput = new DefaultTrackOutput(this.allocator);
        this.sampleQueues.put(n, (Object)defaultTrackOutput);
        return defaultTrackOutput;
    }

    @Override
    public void endTracks() {
        this.tracksBuilt = true;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
    }
}

