/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.wav;

final class WavHeader {
    private final int numChannels;
    private final int sampleRateHz;
    private final int averageBytesPerSecond;
    private final int blockAlignment;
    private final int bitsPerSample;
    private long dataStartPosition;
    private long dataSize;

    public WavHeader(int n, int n2, int n3, int n4, int n5) {
        this.numChannels = n;
        this.sampleRateHz = n2;
        this.averageBytesPerSecond = n3;
        this.blockAlignment = n4;
        this.bitsPerSample = n5;
    }

    public long getDurationUs() {
        return this.getNumFrames() * 1000000L / (long)this.sampleRateHz;
    }

    public long getNumSamples() {
        return this.dataSize / (long)this.getBytesPerSample();
    }

    public long getNumFrames() {
        return this.getNumSamples() / (long)this.getNumChannels();
    }

    public int getBytesPerSample() {
        return this.blockAlignment / this.numChannels;
    }

    public int getBytesPerFrame() {
        return this.blockAlignment;
    }

    public int getBitrate() {
        return this.sampleRateHz * this.bitsPerSample * this.numChannels;
    }

    public int getSampleRateHz() {
        return this.sampleRateHz;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public long getPosition(long l) {
        long l2 = l * (long)this.averageBytesPerSecond / 1000000L;
        return l2 / (long)this.numChannels * (long)this.numChannels + this.dataStartPosition;
    }

    public long getTimeUs(long l) {
        return l * 1000000L / (long)this.averageBytesPerSecond;
    }

    public boolean hasDataBounds() {
        return this.dataStartPosition != 0L && this.dataSize != 0L;
    }

    public void setDataBounds(long l, long l2) {
        this.dataStartPosition = l;
        this.dataSize = l2;
    }
}

