/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.extractor.ts.NalUnitTargetBuffer;
import com.google.android.exoplayer.extractor.ts.SeiReader;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class H264Reader
extends ElementaryStreamReader {
    private static final int NAL_UNIT_TYPE_SEI = 6;
    private static final int NAL_UNIT_TYPE_SPS = 7;
    private static final int NAL_UNIT_TYPE_PPS = 8;
    private boolean hasOutputFormat;
    private final SeiReader seiReader;
    private final boolean[] prefixFlags;
    private final SampleReader sampleReader;
    private final NalUnitTargetBuffer sps;
    private final NalUnitTargetBuffer pps;
    private final NalUnitTargetBuffer sei;
    private long totalBytesWritten;
    private long pesTimeUs;
    private final ParsableByteArray seiWrapper;

    public H264Reader(TrackOutput trackOutput, SeiReader seiReader, boolean bl, boolean bl2) {
        super(trackOutput);
        this.seiReader = seiReader;
        this.prefixFlags = new boolean[3];
        this.sampleReader = new SampleReader(trackOutput, bl, bl2);
        this.sps = new NalUnitTargetBuffer(7, 128);
        this.pps = new NalUnitTargetBuffer(8, 128);
        this.sei = new NalUnitTargetBuffer(6, 128);
        this.seiWrapper = new ParsableByteArray();
    }

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags(this.prefixFlags);
        this.sps.reset();
        this.pps.reset();
        this.sei.reset();
        this.sampleReader.reset();
        this.totalBytesWritten = 0L;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.pesTimeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        if (parsableByteArray.bytesLeft() > 0) {
            int n = parsableByteArray.getPosition();
            int n2 = parsableByteArray.limit();
            byte[] byArray = parsableByteArray.data;
            this.totalBytesWritten += (long)parsableByteArray.bytesLeft();
            this.output.sampleData(parsableByteArray, parsableByteArray.bytesLeft());
            while (true) {
                int n3;
                if ((n3 = NalUnitUtil.findNalUnit(byArray, n, n2, this.prefixFlags)) == n2) {
                    this.nalUnitData(byArray, n, n2);
                    return;
                }
                int n4 = NalUnitUtil.getNalUnitType(byArray, n3);
                int n5 = n3 - n;
                if (n5 > 0) {
                    this.nalUnitData(byArray, n, n3);
                }
                int n6 = n2 - n3;
                long l = this.totalBytesWritten - (long)n6;
                this.endNalUnit(l, n6, n5 < 0 ? -n5 : 0, this.pesTimeUs);
                this.startNalUnit(l, n4, this.pesTimeUs);
                n = n3 + 3;
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private void startNalUnit(long l, int n, long l2) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            this.sps.startNalUnit(n);
            this.pps.startNalUnit(n);
        }
        this.sei.startNalUnit(n);
        this.sampleReader.startNalUnit(l, n, l2);
    }

    private void nalUnitData(byte[] byArray, int n, int n2) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            this.sps.appendToNalUnit(byArray, n, n2);
            this.pps.appendToNalUnit(byArray, n, n2);
        }
        this.sei.appendToNalUnit(byArray, n, n2);
        this.sampleReader.appendToNalUnit(byArray, n, n2);
    }

    private void endNalUnit(long l, int n, int n2, long l2) {
        if (!this.hasOutputFormat || this.sampleReader.needsSpsPps()) {
            Object object;
            this.sps.endNalUnit(n2);
            this.pps.endNalUnit(n2);
            if (!this.hasOutputFormat) {
                if (this.sps.isCompleted() && this.pps.isCompleted()) {
                    object = new ArrayList();
                    object.add(Arrays.copyOf(this.sps.nalData, this.sps.nalLength));
                    object.add(Arrays.copyOf(this.pps.nalData, this.pps.nalLength));
                    NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit(H264Reader.unescape(this.sps));
                    NalUnitUtil.PpsData ppsData = NalUnitUtil.parsePpsNalUnit(H264Reader.unescape(this.pps));
                    this.output.format(MediaFormat.createVideoFormat(null, "video/avc", -1, -1, -1L, spsData.width, spsData.height, (List<byte[]>)object, -1, spsData.pixelWidthAspectRatio));
                    this.hasOutputFormat = true;
                    this.sampleReader.putSps(spsData);
                    this.sampleReader.putPps(ppsData);
                    this.sps.reset();
                    this.pps.reset();
                }
            } else if (this.sps.isCompleted()) {
                object = NalUnitUtil.parseSpsNalUnit(H264Reader.unescape(this.sps));
                this.sampleReader.putSps((NalUnitUtil.SpsData)object);
                this.sps.reset();
            } else if (this.pps.isCompleted()) {
                object = NalUnitUtil.parsePpsNalUnit(H264Reader.unescape(this.pps));
                this.sampleReader.putPps((NalUnitUtil.PpsData)object);
                this.pps.reset();
            }
        }
        if (this.sei.endNalUnit(n2)) {
            int n3 = NalUnitUtil.unescapeStream(this.sei.nalData, this.sei.nalLength);
            this.seiWrapper.reset(this.sei.nalData, n3);
            this.seiWrapper.setPosition(4);
            this.seiReader.consume(l2, this.seiWrapper);
        }
        this.sampleReader.endNalUnit(l, n);
    }

    private static ParsableBitArray unescape(NalUnitTargetBuffer nalUnitTargetBuffer) {
        int n = NalUnitUtil.unescapeStream(nalUnitTargetBuffer.nalData, nalUnitTargetBuffer.nalLength);
        ParsableBitArray parsableBitArray = new ParsableBitArray(nalUnitTargetBuffer.nalData, n);
        parsableBitArray.skipBits(32);
        return parsableBitArray;
    }

    private static final class SampleReader {
        private static final int DEFAULT_BUFFER_SIZE = 128;
        private static final int NAL_UNIT_TYPE_NON_IDR = 1;
        private static final int NAL_UNIT_TYPE_PARTITION_A = 2;
        private static final int NAL_UNIT_TYPE_IDR = 5;
        private static final int NAL_UNIT_TYPE_AUD = 9;
        private final TrackOutput output;
        private final boolean allowNonIdrKeyframes;
        private final boolean detectAccessUnits;
        private final ParsableBitArray scratch;
        private final SparseArray<NalUnitUtil.SpsData> sps;
        private final SparseArray<NalUnitUtil.PpsData> pps;
        private byte[] buffer;
        private int bufferLength;
        private int nalUnitType;
        private long nalUnitStartPosition;
        private boolean isFilling;
        private long nalUnitTimeUs;
        private SliceHeaderData previousSliceHeader;
        private SliceHeaderData sliceHeader;
        private boolean readingSample;
        private long samplePosition;
        private long sampleTimeUs;
        private boolean sampleIsKeyframe;

        public SampleReader(TrackOutput trackOutput, boolean bl, boolean bl2) {
            this.output = trackOutput;
            this.allowNonIdrKeyframes = bl;
            this.detectAccessUnits = bl2;
            this.sps = new SparseArray();
            this.pps = new SparseArray();
            this.previousSliceHeader = new SliceHeaderData();
            this.sliceHeader = new SliceHeaderData();
            this.scratch = new ParsableBitArray();
            this.buffer = new byte[128];
            this.reset();
        }

        public boolean needsSpsPps() {
            return this.detectAccessUnits;
        }

        public void putSps(NalUnitUtil.SpsData spsData) {
            this.sps.append(spsData.seqParameterSetId, (Object)spsData);
        }

        public void putPps(NalUnitUtil.PpsData ppsData) {
            this.pps.append(ppsData.picParameterSetId, (Object)ppsData);
        }

        public void reset() {
            this.isFilling = false;
            this.readingSample = false;
            this.sliceHeader.clear();
        }

        public void startNalUnit(long l, int n, long l2) {
            this.nalUnitType = n;
            this.nalUnitTimeUs = l2;
            this.nalUnitStartPosition = l;
            if (this.allowNonIdrKeyframes && this.nalUnitType == 1 || this.detectAccessUnits && (this.nalUnitType == 5 || this.nalUnitType == 1 || this.nalUnitType == 2)) {
                SliceHeaderData sliceHeaderData = this.previousSliceHeader;
                this.previousSliceHeader = this.sliceHeader;
                this.sliceHeader = sliceHeaderData;
                this.sliceHeader.clear();
                this.bufferLength = 0;
                this.isFilling = true;
            }
        }

        public void appendToNalUnit(byte[] byArray, int n, int n2) {
            if (!this.isFilling) {
                return;
            }
            int n3 = n2 - n;
            if (this.buffer.length < this.bufferLength + n3) {
                this.buffer = Arrays.copyOf(this.buffer, (this.bufferLength + n3) * 2);
            }
            System.arraycopy(byArray, n, this.buffer, this.bufferLength, n3);
            this.bufferLength += n3;
            this.scratch.reset(this.buffer, this.bufferLength);
            if (this.scratch.bitsLeft() < 8) {
                return;
            }
            this.scratch.skipBits(1);
            int n4 = this.scratch.readBits(2);
            this.scratch.skipBits(5);
            if (!this.scratch.canReadExpGolombCodedNum()) {
                return;
            }
            this.scratch.readUnsignedExpGolombCodedInt();
            if (!this.scratch.canReadExpGolombCodedNum()) {
                return;
            }
            int n5 = this.scratch.readUnsignedExpGolombCodedInt();
            if (!this.detectAccessUnits) {
                this.isFilling = false;
                this.sliceHeader.setSliceType(n5);
                return;
            }
            if (!this.scratch.canReadExpGolombCodedNum()) {
                return;
            }
            int n6 = this.scratch.readUnsignedExpGolombCodedInt();
            if (this.pps.indexOfKey(n6) < 0) {
                this.isFilling = false;
                return;
            }
            NalUnitUtil.PpsData ppsData = (NalUnitUtil.PpsData)this.pps.get(n6);
            NalUnitUtil.SpsData spsData = (NalUnitUtil.SpsData)this.sps.get(ppsData.seqParameterSetId);
            if (spsData.separateColorPlaneFlag) {
                if (this.scratch.bitsLeft() < 2) {
                    return;
                }
                this.scratch.skipBits(2);
            }
            if (this.scratch.bitsLeft() < spsData.frameNumLength) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n7 = this.scratch.readBits(spsData.frameNumLength);
            if (!spsData.frameMbsOnlyFlag) {
                if (this.scratch.bitsLeft() < 1) {
                    return;
                }
                bl = this.scratch.readBit();
                if (bl) {
                    if (this.scratch.bitsLeft() < 1) {
                        return;
                    }
                    bl3 = this.scratch.readBit();
                    bl2 = true;
                }
            }
            boolean bl4 = this.nalUnitType == 5;
            int n8 = 0;
            if (bl4) {
                if (!this.scratch.canReadExpGolombCodedNum()) {
                    return;
                }
                n8 = this.scratch.readUnsignedExpGolombCodedInt();
            }
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (spsData.picOrderCountType == 0) {
                if (this.scratch.bitsLeft() < spsData.picOrderCntLsbLength) {
                    return;
                }
                n9 = this.scratch.readBits(spsData.picOrderCntLsbLength);
                if (ppsData.bottomFieldPicOrderInFramePresentFlag && !bl) {
                    if (!this.scratch.canReadExpGolombCodedNum()) {
                        return;
                    }
                    n10 = this.scratch.readSignedExpGolombCodedInt();
                }
            } else if (spsData.picOrderCountType == 1 && !spsData.deltaPicOrderAlwaysZeroFlag) {
                if (!this.scratch.canReadExpGolombCodedNum()) {
                    return;
                }
                n11 = this.scratch.readSignedExpGolombCodedInt();
                if (ppsData.bottomFieldPicOrderInFramePresentFlag && !bl) {
                    if (!this.scratch.canReadExpGolombCodedNum()) {
                        return;
                    }
                    n12 = this.scratch.readSignedExpGolombCodedInt();
                }
            }
            this.sliceHeader.setAll(spsData, n4, n5, n7, n6, bl, bl2, bl3, bl4, n8, n9, n10, n11, n12);
            this.isFilling = false;
        }

        public void endNalUnit(long l, int n) {
            if (this.nalUnitType == 9 || this.detectAccessUnits && this.sliceHeader.isFirstVclNalUnitOfPicture(this.previousSliceHeader)) {
                if (this.readingSample) {
                    int n2 = (int)(l - this.nalUnitStartPosition);
                    this.outputSample(n + n2);
                }
                this.samplePosition = this.nalUnitStartPosition;
                this.sampleTimeUs = this.nalUnitTimeUs;
                this.sampleIsKeyframe = false;
                this.readingSample = true;
            }
            this.sampleIsKeyframe |= this.nalUnitType == 5 || this.allowNonIdrKeyframes && this.nalUnitType == 1 && this.sliceHeader.isISlice();
        }

        private void outputSample(int n) {
            int n2 = this.sampleIsKeyframe ? 1 : 0;
            int n3 = (int)(this.nalUnitStartPosition - this.samplePosition);
            this.output.sampleMetadata(this.sampleTimeUs, n2, n3, n, null);
        }

        private static final class SliceHeaderData {
            private static final int SLICE_TYPE_I = 2;
            private static final int SLICE_TYPE_ALL_I = 7;
            private boolean isComplete;
            private boolean hasSliceType;
            private NalUnitUtil.SpsData spsData;
            private int nalRefIdc;
            private int sliceType;
            private int frameNum;
            private int picParameterSetId;
            private boolean fieldPicFlag;
            private boolean bottomFieldFlagPresent;
            private boolean bottomFieldFlag;
            private boolean idrPicFlag;
            private int idrPicId;
            private int picOrderCntLsb;
            private int deltaPicOrderCntBottom;
            private int deltaPicOrderCnt0;
            private int deltaPicOrderCnt1;

            private SliceHeaderData() {
            }

            public void clear() {
                this.hasSliceType = false;
                this.isComplete = false;
            }

            public void setSliceType(int n) {
                this.sliceType = n;
                this.hasSliceType = true;
            }

            public void setAll(NalUnitUtil.SpsData spsData, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n5, int n6, int n7, int n8, int n9) {
                this.spsData = spsData;
                this.nalRefIdc = n;
                this.sliceType = n2;
                this.frameNum = n3;
                this.picParameterSetId = n4;
                this.fieldPicFlag = bl;
                this.bottomFieldFlagPresent = bl2;
                this.bottomFieldFlag = bl3;
                this.idrPicFlag = bl4;
                this.idrPicId = n5;
                this.picOrderCntLsb = n6;
                this.deltaPicOrderCntBottom = n7;
                this.deltaPicOrderCnt0 = n8;
                this.deltaPicOrderCnt1 = n9;
                this.isComplete = true;
                this.hasSliceType = true;
            }

            public boolean isISlice() {
                return this.hasSliceType && (this.sliceType == 7 || this.sliceType == 2);
            }

            private boolean isFirstVclNalUnitOfPicture(SliceHeaderData sliceHeaderData) {
                return this.isComplete && (!sliceHeaderData.isComplete || this.frameNum != sliceHeaderData.frameNum || this.picParameterSetId != sliceHeaderData.picParameterSetId || this.fieldPicFlag != sliceHeaderData.fieldPicFlag || this.bottomFieldFlagPresent && sliceHeaderData.bottomFieldFlagPresent && this.bottomFieldFlag != sliceHeaderData.bottomFieldFlag || this.nalRefIdc != sliceHeaderData.nalRefIdc && (this.nalRefIdc == 0 || sliceHeaderData.nalRefIdc == 0) || this.spsData.picOrderCountType == 0 && sliceHeaderData.spsData.picOrderCountType == 0 && (this.picOrderCntLsb != sliceHeaderData.picOrderCntLsb || this.deltaPicOrderCntBottom != sliceHeaderData.deltaPicOrderCntBottom) || this.spsData.picOrderCountType == 1 && sliceHeaderData.spsData.picOrderCountType == 1 && (this.deltaPicOrderCnt0 != sliceHeaderData.deltaPicOrderCnt0 || this.deltaPicOrderCnt1 != sliceHeaderData.deltaPicOrderCnt1) || this.idrPicFlag != sliceHeaderData.idrPicFlag || this.idrPicFlag && sliceHeaderData.idrPicFlag && this.idrPicId != sliceHeaderData.idrPicId);
            }
        }
    }
}

