/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.ts.AdtsReader;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class AdtsExtractor
implements Extractor {
    private static final int MAX_PACKET_SIZE = 200;
    private static final int ID3_TAG = Util.getIntegerCodeForString("ID3");
    private static final int MAX_SNIFF_BYTES = 8192;
    private final long firstSampleTimestampUs;
    private final ParsableByteArray packetBuffer;
    private AdtsReader adtsReader;
    private boolean startedPacket;

    public AdtsExtractor() {
        this(0L);
    }

    public AdtsExtractor(long l) {
        this.firstSampleTimestampUs = l;
        this.packetBuffer = new ParsableByteArray(200);
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n;
        ParsableByteArray parsableByteArray = new ParsableByteArray(10);
        ParsableBitArray parsableBitArray = new ParsableBitArray(parsableByteArray.data);
        int n2 = 0;
        while (true) {
            extractorInput.peekFully(parsableByteArray.data, 0, 10);
            parsableByteArray.setPosition(0);
            if (parsableByteArray.readUnsignedInt24() != ID3_TAG) break;
            n = (parsableByteArray.data[6] & 0x7F) << 21 | (parsableByteArray.data[7] & 0x7F) << 14 | (parsableByteArray.data[8] & 0x7F) << 7 | parsableByteArray.data[9] & 0x7F;
            n2 += 10 + n;
            extractorInput.advancePeekPosition(n);
        }
        extractorInput.resetPeekPosition();
        extractorInput.advancePeekPosition(n2);
        n = n2;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            extractorInput.peekFully(parsableByteArray.data, 0, 2);
            parsableByteArray.setPosition(0);
            int n5 = parsableByteArray.readUnsignedShort();
            if ((n5 & 0xFFF6) != 65520) {
                n4 = 0;
                n3 = 0;
                extractorInput.resetPeekPosition();
                if (++n - n2 >= 8192) {
                    return false;
                }
                extractorInput.advancePeekPosition(n);
                continue;
            }
            if (++n4 >= 4 && n3 > 188) {
                return true;
            }
            extractorInput.peekFully(parsableByteArray.data, 0, 4);
            parsableBitArray.setPosition(14);
            int n6 = parsableBitArray.readBits(13);
            extractorInput.advancePeekPosition(n6 - 6);
            n3 += n6;
        }
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.adtsReader = new AdtsReader(extractorOutput.track(0), extractorOutput.track(1));
        extractorOutput.endTracks();
        extractorOutput.seekMap(SeekMap.UNSEEKABLE);
    }

    @Override
    public void seek() {
        this.startedPacket = false;
        this.adtsReader.seek();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        int n = extractorInput.read(this.packetBuffer.data, 0, 200);
        if (n == -1) {
            return -1;
        }
        this.packetBuffer.setPosition(0);
        this.packetBuffer.setLimit(n);
        if (!this.startedPacket) {
            this.adtsReader.packetStarted(this.firstSampleTimestampUs, true);
            this.startedPacket = true;
        }
        this.adtsReader.consume(this.packetBuffer);
        return 0;
    }
}

