/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.Ac3Util;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;

final class Ac3Reader
extends ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int HEADER_SIZE = 8;
    private final boolean isEac3;
    private final ParsableBitArray headerScratchBits;
    private final ParsableByteArray headerScratchBytes;
    private int state;
    private int bytesRead;
    private boolean lastByteWas0B;
    private long sampleDurationUs;
    private MediaFormat mediaFormat;
    private int sampleSize;
    private long timeUs;

    public Ac3Reader(TrackOutput trackOutput, boolean bl) {
        super(trackOutput);
        this.isEac3 = bl;
        this.headerScratchBits = new ParsableBitArray(new byte[8]);
        this.headerScratchBytes = new ParsableByteArray(this.headerScratchBits.data);
        this.state = 0;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.lastByteWas0B = false;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.timeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(parsableByteArray)) break;
                    this.state = 1;
                    this.headerScratchBytes.data[0] = 11;
                    this.headerScratchBytes.data[1] = 119;
                    this.bytesRead = 2;
                    break;
                }
                case 1: {
                    if (!this.continueRead(parsableByteArray, this.headerScratchBytes.data, 8)) break;
                    this.parseHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 8);
                    this.state = 2;
                    break;
                }
                case 2: {
                    int n = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(parsableByteArray, n);
                    this.bytesRead += n;
                    if (this.bytesRead != this.sampleSize) break;
                    this.output.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), n - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n2);
        this.bytesRead += n2;
        return this.bytesRead == n;
    }

    private boolean skipToNextSync(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            if (!this.lastByteWas0B) {
                this.lastByteWas0B = parsableByteArray.readUnsignedByte() == 11;
                continue;
            }
            int n = parsableByteArray.readUnsignedByte();
            if (n == 119) {
                this.lastByteWas0B = false;
                return true;
            }
            this.lastByteWas0B = n == 11;
        }
        return false;
    }

    private void parseHeader() {
        if (this.mediaFormat == null) {
            this.mediaFormat = this.isEac3 ? Ac3Util.parseEac3SyncframeFormat(this.headerScratchBits, null, -1L, null) : Ac3Util.parseAc3SyncframeFormat(this.headerScratchBits, null, -1L, null);
            this.output.format(this.mediaFormat);
        }
        this.sampleSize = this.isEac3 ? Ac3Util.parseEAc3SyncframeSize(this.headerScratchBits.data) : Ac3Util.parseAc3SyncframeSize(this.headerScratchBits.data);
        int n = this.isEac3 ? Ac3Util.parseEAc3SyncframeAudioSampleCount(this.headerScratchBits.data) : Ac3Util.getAc3SyncframeAudioSampleCount();
        this.sampleDurationUs = (int)(1000000L * (long)n / (long)this.mediaFormat.sampleRate);
    }
}

