/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ogg.VorbisBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.util.Arrays;

final class VorbisUtil {
    private static final String TAG = "VorbisUtil";

    VorbisUtil() {
    }

    public static int iLog(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    public static VorbisIdHeader readVorbisIdentificationHeader(ParsableByteArray parsableByteArray) throws ParserException {
        VorbisUtil.verifyVorbisHeaderCapturePattern(1, parsableByteArray, false);
        long l = parsableByteArray.readLittleEndianUnsignedInt();
        int n = parsableByteArray.readUnsignedByte();
        long l2 = parsableByteArray.readLittleEndianUnsignedInt();
        int n2 = parsableByteArray.readLittleEndianInt();
        int n3 = parsableByteArray.readLittleEndianInt();
        int n4 = parsableByteArray.readLittleEndianInt();
        int n5 = parsableByteArray.readUnsignedByte();
        int n6 = (int)Math.pow(2.0, n5 & 0xF);
        int n7 = (int)Math.pow(2.0, (n5 & 0xF0) >> 4);
        boolean bl = (parsableByteArray.readUnsignedByte() & 1) > 0;
        byte[] byArray = Arrays.copyOf(parsableByteArray.data, parsableByteArray.limit());
        return new VorbisIdHeader(l, n, l2, n2, n3, n4, n6, n7, bl, byArray);
    }

    public static CommentHeader readVorbisCommentHeader(ParsableByteArray parsableByteArray) throws ParserException {
        VorbisUtil.verifyVorbisHeaderCapturePattern(3, parsableByteArray, false);
        int n = 7;
        int n2 = (int)parsableByteArray.readLittleEndianUnsignedInt();
        n += 4;
        String string = parsableByteArray.readString(n2);
        n += string.length();
        long l = parsableByteArray.readLittleEndianUnsignedInt();
        String[] stringArray = new String[(int)l];
        n += 4;
        int n3 = 0;
        while ((long)n3 < l) {
            n2 = (int)parsableByteArray.readLittleEndianUnsignedInt();
            n += 4;
            stringArray[n3] = parsableByteArray.readString(n2);
            n += stringArray[n3].length();
            ++n3;
        }
        if ((parsableByteArray.readUnsignedByte() & 1) == 0) {
            throw new ParserException("framing bit expected to be set");
        }
        return new CommentHeader(string, stringArray, ++n);
    }

    public static boolean verifyVorbisHeaderCapturePattern(int n, ParsableByteArray parsableByteArray, boolean bl) throws ParserException {
        if (parsableByteArray.readUnsignedByte() != n) {
            if (bl) {
                return false;
            }
            throw new ParserException("expected header type " + Integer.toHexString(n));
        }
        if (parsableByteArray.readUnsignedByte() != 118 || parsableByteArray.readUnsignedByte() != 111 || parsableByteArray.readUnsignedByte() != 114 || parsableByteArray.readUnsignedByte() != 98 || parsableByteArray.readUnsignedByte() != 105 || parsableByteArray.readUnsignedByte() != 115) {
            if (bl) {
                return false;
            }
            throw new ParserException("expected characters 'vorbis'");
        }
        return true;
    }

    public static Mode[] readVorbisModes(ParsableByteArray parsableByteArray, int n) throws ParserException {
        int n2;
        VorbisUtil.verifyVorbisHeaderCapturePattern(5, parsableByteArray, false);
        int n3 = parsableByteArray.readUnsignedByte() + 1;
        VorbisBitArray vorbisBitArray = new VorbisBitArray(parsableByteArray.data);
        vorbisBitArray.skipBits(parsableByteArray.getPosition() * 8);
        for (n2 = 0; n2 < n3; ++n2) {
            VorbisUtil.readBook(vorbisBitArray);
        }
        n2 = vorbisBitArray.readBits(6) + 1;
        for (int i = 0; i < n2; ++i) {
            if (vorbisBitArray.readBits(16) == 0) continue;
            throw new ParserException("placeholder of time domain transforms not zeroed out");
        }
        VorbisUtil.readFloors(vorbisBitArray);
        VorbisUtil.readResidues(vorbisBitArray);
        VorbisUtil.readMappings(n, vorbisBitArray);
        Mode[] modeArray = VorbisUtil.readModes(vorbisBitArray);
        if (!vorbisBitArray.readBit()) {
            throw new ParserException("framing bit after modes not set as expected");
        }
        return modeArray;
    }

    private static Mode[] readModes(VorbisBitArray vorbisBitArray) {
        int n = vorbisBitArray.readBits(6) + 1;
        Mode[] modeArray = new Mode[n];
        for (int i = 0; i < n; ++i) {
            boolean bl = vorbisBitArray.readBit();
            int n2 = vorbisBitArray.readBits(16);
            int n3 = vorbisBitArray.readBits(16);
            int n4 = vorbisBitArray.readBits(8);
            modeArray[i] = new Mode(bl, n2, n3, n4);
        }
        return modeArray;
    }

    private static void readMappings(int n, VorbisBitArray vorbisBitArray) throws ParserException {
        int n2 = vorbisBitArray.readBits(6) + 1;
        block3: for (int i = 0; i < n2; ++i) {
            int n3 = vorbisBitArray.readBits(16);
            switch (n3) {
                case 0: {
                    int n4;
                    int n5 = vorbisBitArray.readBit() ? vorbisBitArray.readBits(4) + 1 : 1;
                    if (vorbisBitArray.readBit()) {
                        int n6 = vorbisBitArray.readBits(8) + 1;
                        for (n4 = 0; n4 < n6; ++n4) {
                            vorbisBitArray.skipBits(VorbisUtil.iLog(n - 1));
                            vorbisBitArray.skipBits(VorbisUtil.iLog(n - 1));
                        }
                    }
                    if (vorbisBitArray.readBits(2) != 0) {
                        throw new ParserException("to reserved bits must be zero after mapping coupling steps");
                    }
                    if (n5 > 1) {
                        for (n4 = 0; n4 < n; ++n4) {
                            vorbisBitArray.skipBits(4);
                        }
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        vorbisBitArray.skipBits(8);
                        vorbisBitArray.skipBits(8);
                        vorbisBitArray.skipBits(8);
                    }
                    continue block3;
                }
                default: {
                    a.d(TAG, "mapping type other than 0 not supported: " + n3);
                }
            }
        }
    }

    private static void readResidues(VorbisBitArray vorbisBitArray) throws ParserException {
        int n = vorbisBitArray.readBits(6) + 1;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = vorbisBitArray.readBits(16);
            if (n4 > 2) {
                throw new ParserException("residueType greater than 2 is not decodable");
            }
            vorbisBitArray.skipBits(24);
            vorbisBitArray.skipBits(24);
            vorbisBitArray.skipBits(24);
            int n5 = vorbisBitArray.readBits(6) + 1;
            vorbisBitArray.skipBits(8);
            int[] nArray = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = 0;
                int n6 = vorbisBitArray.readBits(3);
                if (vorbisBitArray.readBit()) {
                    n2 = vorbisBitArray.readBits(5);
                }
                nArray[n3] = n2 * 8 + n6;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                for (n2 = 0; n2 < 8; ++n2) {
                    if ((nArray[n3] & 1 << n2) == 0) continue;
                    vorbisBitArray.skipBits(8);
                }
            }
        }
    }

    private static void readFloors(VorbisBitArray vorbisBitArray) throws ParserException {
        int n = vorbisBitArray.readBits(6) + 1;
        block4: for (int i = 0; i < n; ++i) {
            int n2 = vorbisBitArray.readBits(16);
            switch (n2) {
                case 0: {
                    int n3;
                    vorbisBitArray.skipBits(8);
                    vorbisBitArray.skipBits(16);
                    vorbisBitArray.skipBits(16);
                    vorbisBitArray.skipBits(6);
                    vorbisBitArray.skipBits(8);
                    int n4 = vorbisBitArray.readBits(4) + 1;
                    for (n3 = 0; n3 < n4; ++n3) {
                        vorbisBitArray.skipBits(8);
                    }
                    continue block4;
                }
                case 1: {
                    int n5;
                    int n6;
                    int n7;
                    int n3 = vorbisBitArray.readBits(5);
                    int n8 = -1;
                    int[] nArray = new int[n3];
                    for (int j = 0; j < n3; ++j) {
                        nArray[j] = vorbisBitArray.readBits(4);
                        if (nArray[j] <= n8) continue;
                        n8 = nArray[j];
                    }
                    int[] nArray2 = new int[n8 + 1];
                    for (n7 = 0; n7 < nArray2.length; ++n7) {
                        nArray2[n7] = vorbisBitArray.readBits(3) + 1;
                        n6 = vorbisBitArray.readBits(2);
                        if (n6 > 0) {
                            vorbisBitArray.skipBits(8);
                        }
                        for (n5 = 0; n5 < 1 << n6; ++n5) {
                            vorbisBitArray.skipBits(8);
                        }
                    }
                    vorbisBitArray.skipBits(2);
                    n7 = vorbisBitArray.readBits(4);
                    n6 = 0;
                    int n9 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        int n10 = nArray[n5];
                        n6 += nArray2[n10];
                        while (n9 < n6) {
                            vorbisBitArray.skipBits(n7);
                            ++n9;
                        }
                    }
                    continue block4;
                }
                default: {
                    throw new ParserException("floor type greater than 1 not decodable: " + n2);
                }
            }
        }
    }

    private static CodeBook readBook(VorbisBitArray vorbisBitArray) throws ParserException {
        int n;
        int n2;
        if (vorbisBitArray.readBits(24) != 5653314) {
            throw new ParserException("expected code book to start with [0x56, 0x43, 0x42] at " + vorbisBitArray.getPosition());
        }
        int n3 = vorbisBitArray.readBits(16);
        int n4 = vorbisBitArray.readBits(24);
        long[] lArray = new long[n4];
        boolean bl = vorbisBitArray.readBit();
        if (!bl) {
            n2 = vorbisBitArray.readBit();
            for (n = 0; n < lArray.length; ++n) {
                if (n2 != 0) {
                    if (vorbisBitArray.readBit()) {
                        lArray[n] = vorbisBitArray.readBits(5) + 1;
                        continue;
                    }
                    lArray[n] = 0L;
                    continue;
                }
                lArray[n] = vorbisBitArray.readBits(5) + 1;
            }
        } else {
            n2 = vorbisBitArray.readBits(5) + 1;
            n = 0;
            while (n < lArray.length) {
                int n5 = vorbisBitArray.readBits(VorbisUtil.iLog(n4 - n));
                for (int i = 0; i < n5 && n < lArray.length; ++n, ++i) {
                    lArray[n] = n2;
                }
                ++n2;
            }
        }
        if ((n2 = vorbisBitArray.readBits(4)) > 2) {
            throw new ParserException("lookup type greater than 2 not decodable: " + n2);
        }
        if (n2 == 1 || n2 == 2) {
            vorbisBitArray.skipBits(32);
            vorbisBitArray.skipBits(32);
            n = vorbisBitArray.readBits(4) + 1;
            vorbisBitArray.skipBits(1);
            long l = n2 == 1 ? (n3 != 0 ? VorbisUtil.mapType1QuantValues(n4, n3) : 0L) : (long)(n4 * n3);
            vorbisBitArray.skipBits((int)(l * (long)n));
        }
        return new CodeBook(n3, n4, lArray, n2, bl);
    }

    private static long mapType1QuantValues(long l, long l2) {
        return (long)Math.floor(Math.pow(l, 1.0 / (double)l2));
    }

    public static final class Mode {
        public final boolean blockFlag;
        public final int windowType;
        public final int transformType;
        public final int mapping;

        public Mode(boolean bl, int n, int n2, int n3) {
            this.blockFlag = bl;
            this.windowType = n;
            this.transformType = n2;
            this.mapping = n3;
        }
    }

    public static final class VorbisIdHeader {
        public final long version;
        public final int channels;
        public final long sampleRate;
        public final int bitrateMax;
        public final int bitrateNominal;
        public final int bitrateMin;
        public final int blockSize0;
        public final int blockSize1;
        public final boolean framingFlag;
        public final byte[] data;

        public VorbisIdHeader(long l, int n, long l2, int n2, int n3, int n4, int n5, int n6, boolean bl, byte[] byArray) {
            this.version = l;
            this.channels = n;
            this.sampleRate = l2;
            this.bitrateMax = n2;
            this.bitrateNominal = n3;
            this.bitrateMin = n4;
            this.blockSize0 = n5;
            this.blockSize1 = n6;
            this.framingFlag = bl;
            this.data = byArray;
        }

        public int getApproximateBitrate() {
            return this.bitrateNominal == 0 ? (this.bitrateMin + this.bitrateMax) / 2 : this.bitrateNominal;
        }
    }

    public static final class CommentHeader {
        public final String vendor;
        public final String[] comments;
        public final int length;

        public CommentHeader(String string, String[] stringArray, int n) {
            this.vendor = string;
            this.comments = stringArray;
            this.length = n;
        }
    }

    public static final class CodeBook {
        public final int dimensions;
        public final int entries;
        public final long[] lengthMap;
        public final int lookupType;
        public final boolean isOrdered;

        public CodeBook(int n, int n2, long[] lArray, int n3, boolean bl) {
            this.dimensions = n;
            this.entries = n2;
            this.lengthMap = lArray;
            this.lookupType = n3;
            this.isOrdered = bl;
        }
    }
}

