/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;

final class TrackSampleTable {
    public static final int NO_SAMPLE = -1;
    public final int sampleCount;
    public final long[] offsets;
    public final int[] sizes;
    public final int maximumSize;
    public final long[] timestampsUs;
    public final int[] flags;

    TrackSampleTable(long[] lArray, int[] nArray, int n, long[] lArray2, int[] nArray2) {
        Assertions.checkArgument(nArray.length == lArray2.length);
        Assertions.checkArgument(lArray.length == lArray2.length);
        Assertions.checkArgument(nArray2.length == lArray2.length);
        this.offsets = lArray;
        this.sizes = nArray;
        this.maximumSize = n;
        this.timestampsUs = lArray2;
        this.flags = nArray2;
        this.sampleCount = lArray.length;
    }

    public int getIndexOfEarlierOrEqualSynchronizationSample(long l) {
        int n;
        for (int i = n = Util.binarySearchFloor(this.timestampsUs, l, true, false); i >= 0; --i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfLaterOrEqualSynchronizationSample(long l) {
        int n;
        for (int i = n = Util.binarySearchCeil(this.timestampsUs, l, true, false); i < this.timestampsUs.length; ++i) {
            if ((this.flags[i] & 1) == 0) continue;
            return i;
        }
        return -1;
    }
}

