/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

final class Sniffer {
    private static final int[] COMPATIBLE_BRANDS = new int[]{Util.getIntegerCodeForString("isom"), Util.getIntegerCodeForString("iso2"), Util.getIntegerCodeForString("avc1"), Util.getIntegerCodeForString("hvc1"), Util.getIntegerCodeForString("hev1"), Util.getIntegerCodeForString("mp41"), Util.getIntegerCodeForString("mp42"), Util.getIntegerCodeForString("3g2a"), Util.getIntegerCodeForString("3g2b"), Util.getIntegerCodeForString("3gr6"), Util.getIntegerCodeForString("3gs6"), Util.getIntegerCodeForString("3ge6"), Util.getIntegerCodeForString("3gg6"), Util.getIntegerCodeForString("M4V "), Util.getIntegerCodeForString("M4A "), Util.getIntegerCodeForString("f4v "), Util.getIntegerCodeForString("kddi"), Util.getIntegerCodeForString("M4VP"), Util.getIntegerCodeForString("qt  "), Util.getIntegerCodeForString("MSNV")};

    public static boolean sniffFragmented(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffInternal(extractorInput, 4096, true);
    }

    public static boolean sniffUnfragmented(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffInternal(extractorInput, 128, false);
    }

    private static boolean sniffInternal(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        long l = extractorInput.getLength();
        int n2 = (int)(l == -1L || l > (long)n ? (long)n : l);
        ParsableByteArray parsableByteArray = new ParsableByteArray(64);
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n3 < n2) {
            int n4 = 8;
            extractorInput.peekFully(parsableByteArray.data, 0, n4);
            parsableByteArray.setPosition(0);
            long l2 = parsableByteArray.readUnsignedInt();
            int n5 = parsableByteArray.readInt();
            if (l2 == 1L) {
                extractorInput.peekFully(parsableByteArray.data, n4, 16 - n4);
                n4 = 16;
                l2 = parsableByteArray.readLong();
            }
            if (l2 < (long)n4) {
                return false;
            }
            int n6 = (int)l2 - n4;
            if (n5 == Atom.TYPE_ftyp) {
                if (n6 < 8) {
                    return false;
                }
                int n7 = (n6 - 8) / 4;
                extractorInput.peekFully(parsableByteArray.data, 0, 4 * (n7 + 2));
                for (int i = 0; i < n7 + 2; ++i) {
                    if (i == 1 || !Sniffer.isCompatibleBrand(parsableByteArray.readInt())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    return false;
                }
            } else {
                if (n5 == Atom.TYPE_moof) {
                    bl3 = true;
                    break;
                }
                if (n6 != 0) {
                    if ((long)n3 + l2 >= (long)n2) break;
                    extractorInput.advancePeekPosition(n6);
                }
            }
            n3 = (int)((long)n3 + l2);
        }
        return bl2 && bl == bl3;
    }

    private static boolean isCompatibleBrand(int n) {
        if (n >>> 8 == Util.getIntegerCodeForString("3gp")) {
            return true;
        }
        for (int n2 : COMPATIBLE_BRANDS) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private Sniffer() {
    }
}

