/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import android.util.Pair;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.vcc.playerwrappersdk.a;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class PsshAtomUtil {
    private static final String TAG = "PsshAtomUtil";

    private PsshAtomUtil() {
    }

    public static byte[] buildPsshAtom(UUID uUID, byte[] byArray) {
        int n = 32 + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putInt(n);
        byteBuffer.putInt(Atom.TYPE_pssh);
        byteBuffer.putInt(0);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        return byteBuffer.array();
    }

    public static UUID parseUuid(byte[] byArray) {
        Pair<UUID, byte[]> pair = PsshAtomUtil.parsePsshAtom(byArray);
        if (pair == null) {
            return null;
        }
        return (UUID)pair.first;
    }

    public static byte[] parseSchemeSpecificData(byte[] byArray, UUID uUID) {
        Pair<UUID, byte[]> pair = PsshAtomUtil.parsePsshAtom(byArray);
        if (pair == null) {
            return null;
        }
        if (uUID != null && !uUID.equals(pair.first)) {
            a.c(TAG, "UUID mismatch. Expected: " + uUID + ", got: " + pair.first + ".");
            return null;
        }
        return (byte[])pair.second;
    }

    private static Pair<UUID, byte[]> parsePsshAtom(byte[] byArray) {
        int n;
        ParsableByteArray parsableByteArray = new ParsableByteArray(byArray);
        if (parsableByteArray.limit() < 32) {
            return null;
        }
        parsableByteArray.setPosition(0);
        int n2 = parsableByteArray.readInt();
        if (n2 != parsableByteArray.bytesLeft() + 4) {
            return null;
        }
        int n3 = parsableByteArray.readInt();
        if (n3 != Atom.TYPE_pssh) {
            return null;
        }
        int n4 = Atom.parseFullAtomVersion(parsableByteArray.readInt());
        if (n4 > 1) {
            a.c(TAG, "Unsupported pssh version: " + n4);
            return null;
        }
        UUID uUID = new UUID(parsableByteArray.readLong(), parsableByteArray.readLong());
        if (n4 == 1) {
            n = parsableByteArray.readUnsignedIntToInt();
            parsableByteArray.skipBytes(16 * n);
        }
        if ((n = parsableByteArray.readUnsignedIntToInt()) != parsableByteArray.bytesLeft()) {
            return null;
        }
        byte[] byArray2 = new byte[n];
        parsableByteArray.readBytes(byArray2, 0, n);
        return Pair.create((Object)uUID, (Object)byArray2);
    }
}

