/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import android.util.Pair;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.charset.Charset;

final class Id3Util {
    private static final int MAXIMUM_METADATA_SIZE = 0x300000;
    private static final int ID3_TAG = Util.getIntegerCodeForString("ID3");
    private static final Charset[] CHARSET_BY_ENCODING = new Charset[]{Charset.forName("ISO-8859-1"), Charset.forName("UTF-16LE"), Charset.forName("UTF-16BE"), Charset.forName("UTF-8")};

    public static GaplessInfo parseId3(ExtractorInput extractorInput) throws IOException, InterruptedException {
        ParsableByteArray parsableByteArray = new ParsableByteArray(10);
        int n = 0;
        GaplessInfo gaplessInfo = null;
        while (true) {
            extractorInput.peekFully(parsableByteArray.data, 0, 10);
            parsableByteArray.setPosition(0);
            if (parsableByteArray.readUnsignedInt24() != ID3_TAG) break;
            int n2 = parsableByteArray.readUnsignedByte();
            int n3 = parsableByteArray.readUnsignedByte();
            int n4 = parsableByteArray.readUnsignedByte();
            int n5 = parsableByteArray.readSynchSafeInt();
            if (gaplessInfo == null && Id3Util.canParseMetadata(n2, n3, n4, n5)) {
                byte[] byArray = new byte[n5];
                extractorInput.peekFully(byArray, 0, n5);
                gaplessInfo = Id3Util.parseGaplessInfo(new ParsableByteArray(byArray), n2, n4);
            } else {
                extractorInput.advancePeekPosition(n5);
            }
            n += 10 + n5;
        }
        extractorInput.resetPeekPosition();
        extractorInput.advancePeekPosition(n);
        return gaplessInfo;
    }

    private static boolean canParseMetadata(int n, int n2, int n3, int n4) {
        return !(n2 == 255 || n < 2 || n > 4 || n4 > 0x300000 || n == 2 && ((n3 & 0x3F) != 0 || (n3 & 0x40) != 0) || n == 3 && (n3 & 0x1F) != 0 || n == 4 && (n3 & 0xF) != 0);
    }

    private static GaplessInfo parseGaplessInfo(ParsableByteArray parsableByteArray, int n, int n2) {
        Pair<String, String> pair;
        Id3Util.unescape(parsableByteArray, n, n2);
        parsableByteArray.setPosition(0);
        if (n == 3 && (n2 & 0x40) != 0) {
            if (parsableByteArray.bytesLeft() < 4) {
                return null;
            }
            int n3 = parsableByteArray.readUnsignedIntToInt();
            if (n3 > parsableByteArray.bytesLeft()) {
                return null;
            }
            int n4 = 0;
            if (n3 >= 6) {
                parsableByteArray.skipBytes(2);
                n4 = parsableByteArray.readUnsignedIntToInt();
                parsableByteArray.setPosition(4);
                parsableByteArray.setLimit(parsableByteArray.limit() - n4);
                if (parsableByteArray.bytesLeft() < n3) {
                    return null;
                }
            }
            parsableByteArray.skipBytes(n3);
        } else if (n == 4 && (n2 & 0x40) != 0) {
            if (parsableByteArray.bytesLeft() < 4) {
                return null;
            }
            int n5 = parsableByteArray.readSynchSafeInt();
            if (n5 < 6 || n5 > parsableByteArray.bytesLeft() + 4) {
                return null;
            }
            parsableByteArray.setPosition(n5);
        }
        while ((pair = Id3Util.findNextComment(n, parsableByteArray)) != null) {
            GaplessInfo gaplessInfo;
            if (((String)pair.first).length() <= 3 || (gaplessInfo = GaplessInfo.createFromComment(((String)pair.first).substring(3), (String)pair.second)) == null) continue;
            return gaplessInfo;
        }
        return null;
    }

    private static Pair<String, String> findNextComment(int n, ParsableByteArray parsableByteArray) {
        int n2;
        while (true) {
            String string;
            if (n == 2) {
                if (parsableByteArray.bytesLeft() < 6) {
                    return null;
                }
                string = parsableByteArray.readString(3, Charset.forName("US-ASCII"));
                if (string.equals("\u0000\u0000\u0000")) {
                    return null;
                }
                n2 = parsableByteArray.readUnsignedInt24();
                if (n2 == 0 || n2 > parsableByteArray.bytesLeft()) {
                    return null;
                }
                if (string.equals("COM")) {
                    break;
                }
            } else {
                boolean bl;
                if (parsableByteArray.bytesLeft() < 10) {
                    return null;
                }
                string = parsableByteArray.readString(4, Charset.forName("US-ASCII"));
                if (string.equals("\u0000\u0000\u0000\u0000")) {
                    return null;
                }
                int n3 = n2 = n == 4 ? parsableByteArray.readSynchSafeInt() : parsableByteArray.readUnsignedIntToInt();
                if (n2 == 0 || n2 > parsableByteArray.bytesLeft() - 2) {
                    return null;
                }
                int n4 = parsableByteArray.readUnsignedShort();
                boolean bl2 = bl = n == 4 && (n4 & 0xC) != 0 || n == 3 && (n4 & 0xC0) != 0;
                if (!bl && string.equals("COMM")) break;
            }
            parsableByteArray.skipBytes(n2);
        }
        int n5 = parsableByteArray.readUnsignedByte();
        if (n5 < 0 || n5 >= CHARSET_BY_ENCODING.length) {
            return null;
        }
        Charset charset = CHARSET_BY_ENCODING[n5];
        String[] stringArray = parsableByteArray.readString(n2 - 1, charset).split("\u0000");
        return stringArray.length == 2 ? Pair.create((Object)stringArray[0], (Object)stringArray[1]) : null;
    }

    private static boolean unescape(ParsableByteArray parsableByteArray, int n, int n2) {
        if (n != 4) {
            if ((n2 & 0x80) != 0) {
                byte[] byArray = parsableByteArray.data;
                int n3 = byArray.length;
                int n4 = 0;
                while (n4 + 1 < n3) {
                    if ((byArray[n4] & 0xFF) == 255 && byArray[n4 + 1] == 0) {
                        System.arraycopy(byArray, n4 + 2, byArray, n4 + 1, n3 - n4 - 2);
                        --n3;
                    }
                    ++n4;
                }
                parsableByteArray.setLimit(n3);
            }
        } else if (Id3Util.canUnescapeVersion4(parsableByteArray, false)) {
            Id3Util.unescapeVersion4(parsableByteArray, false);
        } else if (Id3Util.canUnescapeVersion4(parsableByteArray, true)) {
            Id3Util.unescapeVersion4(parsableByteArray, true);
        } else {
            return false;
        }
        return true;
    }

    private static boolean canUnescapeVersion4(ParsableByteArray parsableByteArray, boolean bl) {
        parsableByteArray.setPosition(0);
        while (parsableByteArray.bytesLeft() >= 10) {
            if (parsableByteArray.readInt() == 0) {
                return true;
            }
            long l = parsableByteArray.readUnsignedInt();
            if (!bl) {
                if ((l & 0x808080L) != 0L) {
                    return false;
                }
                l = l & 0x7FL | (l >> 8 & 0x7FL) << 7 | (l >> 16 & 0x7FL) << 14 | (l >> 24 & 0x7FL) << 21;
            }
            if (l > (long)(parsableByteArray.bytesLeft() - 2)) {
                return false;
            }
            int n = parsableByteArray.readUnsignedShort();
            if ((n & 1) != 0 && parsableByteArray.bytesLeft() < 4) {
                return false;
            }
            parsableByteArray.skipBytes((int)l);
        }
        return true;
    }

    private static void unescapeVersion4(ParsableByteArray parsableByteArray, boolean bl) {
        parsableByteArray.setPosition(0);
        byte[] byArray = parsableByteArray.data;
        while (parsableByteArray.bytesLeft() >= 10) {
            int n;
            int n2;
            if (parsableByteArray.readInt() == 0) {
                return;
            }
            int n3 = bl ? parsableByteArray.readUnsignedIntToInt() : parsableByteArray.readSynchSafeInt();
            int n4 = n2 = parsableByteArray.readUnsignedShort();
            if ((n2 & 1) != 0) {
                n = parsableByteArray.getPosition();
                System.arraycopy(byArray, n + 4, byArray, n, parsableByteArray.bytesLeft() - 4);
                n3 -= 4;
                n2 &= 0xFFFFFFFE;
                parsableByteArray.setLimit(parsableByteArray.limit() - 4);
            }
            if ((n2 & 2) != 0) {
                int n5 = n = parsableByteArray.getPosition() + 1;
                int n6 = 0;
                while (n6 + 1 < n3) {
                    if ((byArray[n - 1] & 0xFF) == 255 && byArray[n] == 0) {
                        --n3;
                    }
                    int n7 = n5++;
                    int n8 = ++n;
                    ++n;
                    byArray[n7] = byArray[n8];
                    ++n6;
                }
                parsableByteArray.setLimit(parsableByteArray.limit() - (n - n5));
                System.arraycopy(byArray, n, byArray, n5, parsableByteArray.bytesLeft() - n);
                n2 &= 0xFFFFFFFD;
            }
            if (n2 != n4 || bl) {
                n = parsableByteArray.getPosition() - 6;
                Id3Util.writeSyncSafeInteger(byArray, n, n3);
                byArray[n + 4] = (byte)(n2 >> 8);
                byArray[n + 5] = (byte)(n2 & 0xFF);
            }
            parsableByteArray.skipBytes(n3);
        }
    }

    private static void writeSyncSafeInteger(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 21 & 0x7F);
        byArray[n + 1] = (byte)(n2 >> 14 & 0x7F);
        byArray[n + 2] = (byte)(n2 >> 7 & 0x7F);
        byArray[n + 3] = (byte)(n2 & 0x7F);
    }

    private Id3Util() {
    }
}

