/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GaplessInfo {
    private static final String GAPLESS_COMMENT_ID = "iTunSMPB";
    private static final Pattern GAPLESS_COMMENT_PATTERN = Pattern.compile("^ [0-9a-fA-F]{8} ([0-9a-fA-F]{8}) ([0-9a-fA-F]{8})");
    public final int encoderDelay;
    public final int encoderPadding;

    public static GaplessInfo createFromComment(String string, String string2) {
        if (!GAPLESS_COMMENT_ID.equals(string)) {
            return null;
        }
        Matcher matcher = GAPLESS_COMMENT_PATTERN.matcher(string2);
        if (matcher.find()) {
            try {
                int n = Integer.parseInt(matcher.group(1), 16);
                int n2 = Integer.parseInt(matcher.group(2), 16);
                return n == 0 && n2 == 0 ? null : new GaplessInfo(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static GaplessInfo createFromXingHeaderValue(int n) {
        int n2 = n >> 12;
        int n3 = n & 0xFFF;
        return n2 == 0 && n3 == 0 ? null : new GaplessInfo(n2, n3);
    }

    private GaplessInfo(int n, int n2) {
        this.encoderDelay = n;
        this.encoderPadding = n2;
    }
}

