/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.util.SparseArray;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ExtractorSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
ExtractorOutput,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_ON_DEMAND = 3;
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_LIVE = 6;
    private static final int MIN_RETRY_COUNT_DEFAULT_FOR_MEDIA = -1;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private static final List<Class<? extends Extractor>> DEFAULT_EXTRACTOR_CLASSES = new ArrayList<Class<? extends Extractor>>();
    private final ExtractorHolder extractorHolder;
    private final Allocator allocator;
    private final int requestedBufferSize;
    private final SparseArray<InternalTrackOutput> sampleQueues;
    private final int minLoadableRetryCount;
    private final Uri uri;
    private final DataSource dataSource;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int eventSourceId;
    private volatile boolean tracksBuilt;
    private volatile SeekMap seekMap;
    private volatile DrmInitData drmInitData;
    private boolean prepared;
    private int enabledTrackCount;
    private MediaFormat[] mediaFormats;
    private long maxTrackDurationUs;
    private boolean[] pendingMediaFormat;
    private boolean[] pendingDiscontinuities;
    private boolean[] trackEnabledStates;
    private int remainingReleaseCount;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean havePendingNextSampleUs;
    private long pendingNextSampleUs;
    private long sampleTimeOffsetUs;
    private Loader loader;
    private ExtractingLoadable loadable;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private boolean loadingFinished;
    private int extractedSampleCount;
    private int extractedSampleCountAtStartOfLoad;

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int n, Extractor ... extractorArray) {
        this(uri, dataSource, allocator, n, -1, extractorArray);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int n, Handler handler, EventListener eventListener, int n2, Extractor ... extractorArray) {
        this(uri, dataSource, allocator, n, -1, handler, eventListener, n2, extractorArray);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int n, int n2, Extractor ... extractorArray) {
        this(uri, dataSource, allocator, n, n2, null, null, 0, extractorArray);
    }

    public ExtractorSampleSource(Uri uri, DataSource dataSource, Allocator allocator, int n, int n2, Handler handler, EventListener eventListener, int n3, Extractor ... extractorArray) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.eventListener = eventListener;
        this.eventHandler = handler;
        this.eventSourceId = n3;
        this.allocator = allocator;
        this.requestedBufferSize = n;
        this.minLoadableRetryCount = n2;
        if (extractorArray == null || extractorArray.length == 0) {
            extractorArray = new Extractor[DEFAULT_EXTRACTOR_CLASSES.size()];
            for (int i = 0; i < extractorArray.length; ++i) {
                try {
                    extractorArray[i] = DEFAULT_EXTRACTOR_CLASSES.get(i).newInstance();
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Unexpected error creating default extractor", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Unexpected error creating default extractor", illegalAccessException);
                }
            }
        }
        this.extractorHolder = new ExtractorHolder(extractorArray, this);
        this.sampleQueues = new SparseArray();
        this.pendingResetPositionUs = Long.MIN_VALUE;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long l) {
        if (this.prepared) {
            return true;
        }
        if (this.loader == null) {
            this.loader = new Loader("Loader:ExtractorSampleSource");
        }
        this.maybeStartLoading();
        if (this.seekMap != null && this.tracksBuilt && this.haveFormatsForAllTracks()) {
            int n = this.sampleQueues.size();
            this.trackEnabledStates = new boolean[n];
            this.pendingDiscontinuities = new boolean[n];
            this.pendingMediaFormat = new boolean[n];
            this.mediaFormats = new MediaFormat[n];
            this.maxTrackDurationUs = -1L;
            for (int i = 0; i < n; ++i) {
                MediaFormat mediaFormat;
                this.mediaFormats[i] = mediaFormat = ((InternalTrackOutput)this.sampleQueues.valueAt(i)).getFormat();
                if (mediaFormat.durationUs == -1L || mediaFormat.durationUs <= this.maxTrackDurationUs) continue;
                this.maxTrackDurationUs = mediaFormat.durationUs;
            }
            this.prepared = true;
            return true;
        }
        return false;
    }

    @Override
    public int getTrackCount() {
        return this.sampleQueues.size();
    }

    @Override
    public MediaFormat getFormat(int n) {
        Assertions.checkState(this.prepared);
        return this.mediaFormats[n];
    }

    @Override
    public void enable(int n, long l) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(!this.trackEnabledStates[n]);
        ++this.enabledTrackCount;
        this.trackEnabledStates[n] = true;
        this.pendingMediaFormat[n] = true;
        this.pendingDiscontinuities[n] = false;
        if (this.enabledTrackCount == 1) {
            this.downstreamPositionUs = l = !this.seekMap.isSeekable() ? 0L : l;
            this.lastSeekPositionUs = l;
            this.restartFrom(l);
        }
    }

    @Override
    public void disable(int n) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[n]);
        --this.enabledTrackCount;
        this.trackEnabledStates[n] = false;
        if (this.enabledTrackCount == 0) {
            this.downstreamPositionUs = Long.MIN_VALUE;
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.clearState();
                this.allocator.trim(0);
            }
        }
    }

    @Override
    public boolean continueBuffering(int n, long l) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[n]);
        this.downstreamPositionUs = l;
        this.discardSamplesForDisabledTracks(this.downstreamPositionUs);
        if (this.loadingFinished) {
            return true;
        }
        this.maybeStartLoading();
        if (this.isPendingReset()) {
            return false;
        }
        return !((InternalTrackOutput)this.sampleQueues.valueAt(n)).isEmpty();
    }

    @Override
    public long readDiscontinuity(int n) {
        if (this.pendingDiscontinuities[n]) {
            this.pendingDiscontinuities[n] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int n, long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        this.downstreamPositionUs = l;
        if (this.pendingDiscontinuities[n] || this.isPendingReset()) {
            return -2;
        }
        InternalTrackOutput internalTrackOutput = (InternalTrackOutput)this.sampleQueues.valueAt(n);
        if (this.pendingMediaFormat[n]) {
            mediaFormatHolder.format = internalTrackOutput.getFormat();
            mediaFormatHolder.drmInitData = this.drmInitData;
            this.pendingMediaFormat[n] = false;
            return -4;
        }
        if (internalTrackOutput.getSample(sampleHolder)) {
            boolean bl = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (bl ? 0x8000000 : 0);
            if (this.havePendingNextSampleUs) {
                this.sampleTimeOffsetUs = this.pendingNextSampleUs - sampleHolder.timeUs;
                this.havePendingNextSampleUs = false;
            }
            sampleHolder.timeUs += this.sampleTimeOffsetUs;
            return -3;
        }
        if (this.loadingFinished) {
            return -1;
        }
        return -2;
    }

    @Override
    public void maybeThrowError() throws IOException {
        int n;
        if (this.currentLoadableException == null) {
            return;
        }
        if (this.isCurrentLoadableExceptionFatal()) {
            throw this.currentLoadableException;
        }
        if (this.minLoadableRetryCount != -1) {
            n = this.minLoadableRetryCount;
        } else {
            int n2 = n = this.seekMap != null && !this.seekMap.isSeekable() ? 6 : 3;
        }
        if (this.currentLoadableExceptionCount > n) {
            throw this.currentLoadableException;
        }
    }

    @Override
    public void seekToUs(long l) {
        int n;
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        l = !this.seekMap.isSeekable() ? 0L : l;
        long l2 = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = l;
        this.lastSeekPositionUs = l;
        if (l2 == l) {
            return;
        }
        boolean bl = !this.isPendingReset();
        for (n = 0; bl && n < this.sampleQueues.size(); bl &= ((InternalTrackOutput)this.sampleQueues.valueAt(n)).skipToKeyframeBefore(l), ++n) {
        }
        if (!bl) {
            this.restartFrom(l);
        }
        for (n = 0; n < this.pendingDiscontinuities.length; ++n) {
            this.pendingDiscontinuities[n] = true;
        }
    }

    @Override
    public long getBufferedPositionUs() {
        if (this.loadingFinished) {
            return -3L;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long l = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            l = Math.max(l, ((InternalTrackOutput)this.sampleQueues.valueAt(i)).getLargestParsedTimestampUs());
        }
        return l == Long.MIN_VALUE ? this.downstreamPositionUs : l;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0) {
            if (this.loader != null) {
                this.loader.release();
                this.loader = null;
            }
            if (this.extractorHolder.extractor != null) {
                this.extractorHolder.extractor.release();
                this.extractorHolder.extractor = null;
            }
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        this.loadingFinished = true;
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        if (this.enabledTrackCount > 0) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.clearState();
            this.allocator.trim(0);
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        this.currentLoadableException = iOException;
        this.currentLoadableExceptionCount = this.extractedSampleCount > this.extractedSampleCountAtStartOfLoad ? 1 : this.currentLoadableExceptionCount + 1;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(iOException);
        this.maybeStartLoading();
    }

    @Override
    public TrackOutput track(int n) {
        InternalTrackOutput internalTrackOutput = (InternalTrackOutput)this.sampleQueues.get(n);
        if (internalTrackOutput == null) {
            internalTrackOutput = new InternalTrackOutput(this.allocator);
            this.sampleQueues.put(n, (Object)internalTrackOutput);
        }
        return internalTrackOutput;
    }

    @Override
    public void endTracks() {
        this.tracksBuilt = true;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
        this.drmInitData = drmInitData;
    }

    private void restartFrom(long l) {
        this.pendingResetPositionUs = l;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearState();
            this.maybeStartLoading();
        }
    }

    private void maybeStartLoading() {
        if (this.loadingFinished || this.loader.isLoading()) {
            return;
        }
        if (this.currentLoadableException != null) {
            if (this.isCurrentLoadableExceptionFatal()) {
                return;
            }
            Assertions.checkState(this.loadable != null);
            long l = SystemClock.elapsedRealtime() - this.currentLoadableExceptionTimestamp;
            if (l >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.currentLoadableException = null;
                if (!this.prepared) {
                    for (int i = 0; i < this.sampleQueues.size(); ++i) {
                        ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
                    }
                    this.loadable = this.createLoadableFromStart();
                } else if (!this.seekMap.isSeekable() && this.maxTrackDurationUs == -1L) {
                    for (int i = 0; i < this.sampleQueues.size(); ++i) {
                        ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
                    }
                    this.loadable = this.createLoadableFromStart();
                    this.pendingNextSampleUs = this.downstreamPositionUs;
                    this.havePendingNextSampleUs = true;
                }
                this.extractedSampleCountAtStartOfLoad = this.extractedSampleCount;
                this.loader.startLoading(this.loadable, this);
            }
            return;
        }
        this.sampleTimeOffsetUs = 0L;
        this.havePendingNextSampleUs = false;
        if (!this.prepared) {
            this.loadable = this.createLoadableFromStart();
        } else {
            Assertions.checkState(this.isPendingReset());
            if (this.maxTrackDurationUs != -1L && this.pendingResetPositionUs >= this.maxTrackDurationUs) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = Long.MIN_VALUE;
                return;
            }
            this.loadable = this.createLoadableFromPositionUs(this.pendingResetPositionUs);
            this.pendingResetPositionUs = Long.MIN_VALUE;
        }
        this.extractedSampleCountAtStartOfLoad = this.extractedSampleCount;
        this.loader.startLoading(this.loadable, this);
    }

    private ExtractingLoadable createLoadableFromStart() {
        return new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this.allocator, this.requestedBufferSize, 0L);
    }

    private ExtractingLoadable createLoadableFromPositionUs(long l) {
        return new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this.allocator, this.requestedBufferSize, this.seekMap.getPosition(l));
    }

    private boolean haveFormatsForAllTracks() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            if (((InternalTrackOutput)this.sampleQueues.valueAt(i)).hasFormat()) continue;
            return false;
        }
        return true;
    }

    private void discardSamplesForDisabledTracks(long l) {
        for (int i = 0; i < this.trackEnabledStates.length; ++i) {
            if (this.trackEnabledStates[i]) continue;
            ((InternalTrackOutput)this.sampleQueues.valueAt(i)).discardUntil(l);
        }
    }

    private void clearState() {
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            ((InternalTrackOutput)this.sampleQueues.valueAt(i)).clear();
        }
        this.loadable = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private boolean isCurrentLoadableExceptionFatal() {
        return this.currentLoadableException instanceof UnrecognizedInputFormatException;
    }

    private long getRetryDelayMillis(long l) {
        return Math.min((l - 1L) * 1000L, 5000L);
    }

    private void notifyLoadError(final IOException iOException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ExtractorSampleSource.this.eventListener.onLoadError(ExtractorSampleSource.this.eventSourceId, iOException);
                }
            });
        }
    }

    static {
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.webm.WebmExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp4.FragmentedMp4Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp4.Mp4Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.mp3.Mp3Extractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.AdtsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.TsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.flv.FlvExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ogg.OggVorbisExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.ts.PsExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.extractor.wav.WavExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            DEFAULT_EXTRACTOR_CLASSES.add(Class.forName("com.google.android.exoplayer.ext.flac.FlacExtractor").asSubclass(Extractor.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static final class ExtractorHolder {
        private final Extractor[] extractors;
        private final ExtractorOutput extractorOutput;
        private Extractor extractor;

        public ExtractorHolder(Extractor[] extractorArray, ExtractorOutput extractorOutput) {
            this.extractors = extractorArray;
            this.extractorOutput = extractorOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Extractor selectExtractor(ExtractorInput extractorInput) throws UnrecognizedInputFormatException, IOException, InterruptedException {
            if (this.extractor != null) {
                return this.extractor;
            }
            for (Extractor extractor : this.extractors) {
                try {
                    if (!extractor.sniff(extractorInput)) continue;
                    this.extractor = extractor;
                    break;
                }
                catch (EOFException eOFException) {
                }
                finally {
                    extractorInput.resetPeekPosition();
                }
            }
            if (this.extractor == null) {
                throw new UnrecognizedInputFormatException(this.extractors);
            }
            this.extractor.init(this.extractorOutput);
            return this.extractor;
        }
    }

    private static class ExtractingLoadable
    implements Loader.Loadable {
        private final Uri uri;
        private final DataSource dataSource;
        private final ExtractorHolder extractorHolder;
        private final Allocator allocator;
        private final int requestedBufferSize;
        private final PositionHolder positionHolder;
        private volatile boolean loadCanceled;
        private boolean pendingExtractorSeek;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ExtractorHolder extractorHolder, Allocator allocator, int n, long l) {
            this.uri = Assertions.checkNotNull(uri);
            this.dataSource = Assertions.checkNotNull(dataSource);
            this.extractorHolder = Assertions.checkNotNull(extractorHolder);
            this.allocator = Assertions.checkNotNull(allocator);
            this.requestedBufferSize = n;
            this.positionHolder = new PositionHolder();
            this.positionHolder.position = l;
            this.pendingExtractorSeek = true;
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        @Override
        public boolean isLoadCanceled() {
            return this.loadCanceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException, InterruptedException {
            int n = 0;
            while (n == 0 && !this.loadCanceled) {
                ExtractorInput extractorInput = null;
                try {
                    long l = this.positionHolder.position;
                    long l2 = this.dataSource.open(new DataSpec(this.uri, l, -1L, null));
                    if (l2 != -1L) {
                        l2 += l;
                    }
                    extractorInput = new DefaultExtractorInput(this.dataSource, l, l2);
                    Extractor extractor = this.extractorHolder.selectExtractor(extractorInput);
                    if (this.pendingExtractorSeek) {
                        extractor.seek();
                        this.pendingExtractorSeek = false;
                    }
                    while (n == 0 && !this.loadCanceled) {
                        this.allocator.blockWhileTotalBytesAllocatedExceeds(this.requestedBufferSize);
                        n = extractor.read(extractorInput, this.positionHolder);
                    }
                }
                finally {
                    if (n == 1) {
                        n = 0;
                    } else if (extractorInput != null) {
                        this.positionHolder.position = extractorInput.getPosition();
                    }
                    this.dataSource.close();
                }
            }
        }
    }

    private class InternalTrackOutput
    extends DefaultTrackOutput {
        public InternalTrackOutput(Allocator allocator) {
            super(allocator);
        }

        @Override
        public void sampleMetadata(long l, int n, int n2, int n3, byte[] byArray) {
            super.sampleMetadata(l, n, n2, n3, byArray);
            ExtractorSampleSource.this.extractedSampleCount++;
        }
    }

    public static final class UnrecognizedInputFormatException
    extends ParserException {
        public UnrecognizedInputFormatException(Extractor[] extractorArray) {
            super("None of the available extractors (" + Util.getCommaDelimitedSimpleClassNames(extractorArray) + ") could read the stream.");
        }
    }

    public static interface EventListener {
        public void onLoadError(int var1, IOException var2);
    }
}

