/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.RollingSampleBuffer;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

public class DefaultTrackOutput
implements TrackOutput {
    private final RollingSampleBuffer rollingBuffer;
    private final SampleHolder sampleInfoHolder;
    private boolean needKeyframe;
    private long lastReadTimeUs;
    private long spliceOutTimeUs;
    private volatile long largestParsedTimestampUs;
    private volatile MediaFormat format;

    public DefaultTrackOutput(Allocator allocator) {
        this.rollingBuffer = new RollingSampleBuffer(allocator);
        this.sampleInfoHolder = new SampleHolder(0);
        this.needKeyframe = true;
        this.lastReadTimeUs = Long.MIN_VALUE;
        this.spliceOutTimeUs = Long.MIN_VALUE;
        this.largestParsedTimestampUs = Long.MIN_VALUE;
    }

    public void clear() {
        this.rollingBuffer.clear();
        this.needKeyframe = true;
        this.lastReadTimeUs = Long.MIN_VALUE;
        this.spliceOutTimeUs = Long.MIN_VALUE;
        this.largestParsedTimestampUs = Long.MIN_VALUE;
    }

    public int getWriteIndex() {
        return this.rollingBuffer.getWriteIndex();
    }

    public void discardUpstreamSamples(int n) {
        this.rollingBuffer.discardUpstreamSamples(n);
        this.largestParsedTimestampUs = this.rollingBuffer.peekSample(this.sampleInfoHolder) ? this.sampleInfoHolder.timeUs : Long.MIN_VALUE;
    }

    public int getReadIndex() {
        return this.rollingBuffer.getReadIndex();
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public MediaFormat getFormat() {
        return this.format;
    }

    public long getLargestParsedTimestampUs() {
        return this.largestParsedTimestampUs;
    }

    public boolean isEmpty() {
        return !this.advanceToEligibleSample();
    }

    public boolean getSample(SampleHolder sampleHolder) {
        boolean bl = this.advanceToEligibleSample();
        if (!bl) {
            return false;
        }
        this.rollingBuffer.readSample(sampleHolder);
        this.needKeyframe = false;
        this.lastReadTimeUs = sampleHolder.timeUs;
        return true;
    }

    public void discardUntil(long l) {
        while (this.rollingBuffer.peekSample(this.sampleInfoHolder) && this.sampleInfoHolder.timeUs < l) {
            this.rollingBuffer.skipSample();
            this.needKeyframe = true;
        }
        this.lastReadTimeUs = Long.MIN_VALUE;
    }

    public boolean skipToKeyframeBefore(long l) {
        return this.rollingBuffer.skipToKeyframeBefore(l);
    }

    public boolean configureSpliceTo(DefaultTrackOutput defaultTrackOutput) {
        if (this.spliceOutTimeUs != Long.MIN_VALUE) {
            return true;
        }
        long l = this.rollingBuffer.peekSample(this.sampleInfoHolder) ? this.sampleInfoHolder.timeUs : this.lastReadTimeUs + 1L;
        RollingSampleBuffer rollingSampleBuffer = defaultTrackOutput.rollingBuffer;
        while (rollingSampleBuffer.peekSample(this.sampleInfoHolder) && (this.sampleInfoHolder.timeUs < l || !this.sampleInfoHolder.isSyncFrame())) {
            rollingSampleBuffer.skipSample();
        }
        if (rollingSampleBuffer.peekSample(this.sampleInfoHolder)) {
            this.spliceOutTimeUs = this.sampleInfoHolder.timeUs;
            return true;
        }
        return false;
    }

    private boolean advanceToEligibleSample() {
        boolean bl = this.rollingBuffer.peekSample(this.sampleInfoHolder);
        if (this.needKeyframe) {
            while (bl && !this.sampleInfoHolder.isSyncFrame()) {
                this.rollingBuffer.skipSample();
                bl = this.rollingBuffer.peekSample(this.sampleInfoHolder);
            }
        }
        if (!bl) {
            return false;
        }
        return this.spliceOutTimeUs == Long.MIN_VALUE || this.sampleInfoHolder.timeUs < this.spliceOutTimeUs;
    }

    public int sampleData(DataSource dataSource, int n, boolean bl) throws IOException {
        return this.rollingBuffer.appendData(dataSource, n, bl);
    }

    @Override
    public void format(MediaFormat mediaFormat) {
        this.format = mediaFormat;
    }

    @Override
    public int sampleData(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        return this.rollingBuffer.appendData(extractorInput, n, bl);
    }

    @Override
    public void sampleData(ParsableByteArray parsableByteArray, int n) {
        this.rollingBuffer.appendData(parsableByteArray, n);
    }

    @Override
    public void sampleMetadata(long l, int n, int n2, int n3, byte[] byArray) {
        this.largestParsedTimestampUs = Math.max(this.largestParsedTimestampUs, l);
        this.rollingBuffer.commitSample(l, n, this.rollingBuffer.getWritePosition() - (long)n2 - (long)n3, n2, byArray);
    }
}

