/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.upstream.DataSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public final class DefaultExtractorInput
implements ExtractorInput {
    private static final byte[] SCRATCH_SPACE = new byte[4096];
    private final DataSource dataSource;
    private final long streamLength;
    private long position;
    private byte[] peekBuffer;
    private int peekBufferPosition;
    private int peekBufferLength;

    public DefaultExtractorInput(DataSource dataSource, long l, long l2) {
        this.dataSource = dataSource;
        this.position = l;
        this.streamLength = l2;
        this.peekBuffer = new byte[8192];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        int n3 = this.readFromPeekBuffer(byArray, n, n2);
        if (n3 == 0) {
            n3 = this.readFromDataSource(byArray, n, n2, 0, true);
        }
        this.commitBytesRead(n3);
        return n3;
    }

    @Override
    public boolean readFully(byte[] byArray, int n, int n2, boolean bl) throws IOException, InterruptedException {
        int n3 = this.readFromPeekBuffer(byArray, n, n2);
        while (n3 < n2 && n3 != -1) {
            n3 = this.readFromDataSource(byArray, n, n2, n3, bl);
        }
        this.commitBytesRead(n3);
        return n3 != -1;
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        this.readFully(byArray, n, n2, false);
    }

    @Override
    public int skip(int n) throws IOException, InterruptedException {
        int n2 = this.skipFromPeekBuffer(n);
        if (n2 == 0) {
            n2 = this.readFromDataSource(SCRATCH_SPACE, 0, Math.min(n, SCRATCH_SPACE.length), 0, true);
        }
        this.commitBytesRead(n2);
        return n2;
    }

    @Override
    public boolean skipFully(int n, boolean bl) throws IOException, InterruptedException {
        int n2 = this.skipFromPeekBuffer(n);
        while (n2 < n && n2 != -1) {
            n2 = this.readFromDataSource(SCRATCH_SPACE, -n2, Math.min(n, n2 + SCRATCH_SPACE.length), n2, bl);
        }
        this.commitBytesRead(n2);
        return n2 != -1;
    }

    @Override
    public void skipFully(int n) throws IOException, InterruptedException {
        this.skipFully(n, false);
    }

    @Override
    public boolean peekFully(byte[] byArray, int n, int n2, boolean bl) throws IOException, InterruptedException {
        if (!this.advancePeekPosition(n2, bl)) {
            return false;
        }
        System.arraycopy(this.peekBuffer, this.peekBufferPosition - n2, byArray, n, n2);
        return true;
    }

    @Override
    public void peekFully(byte[] byArray, int n, int n2) throws IOException, InterruptedException {
        this.peekFully(byArray, n, n2, false);
    }

    @Override
    public boolean advancePeekPosition(int n, boolean bl) throws IOException, InterruptedException {
        this.ensureSpaceForPeek(n);
        int n2 = Math.min(this.peekBufferLength - this.peekBufferPosition, n);
        this.peekBufferLength += n - n2;
        while (n2 < n) {
            if ((n2 = this.readFromDataSource(this.peekBuffer, this.peekBufferPosition, n, n2, bl)) != -1) continue;
            return false;
        }
        this.peekBufferPosition += n;
        return true;
    }

    @Override
    public void advancePeekPosition(int n) throws IOException, InterruptedException {
        this.advancePeekPosition(n, false);
    }

    @Override
    public void resetPeekPosition() {
        this.peekBufferPosition = 0;
    }

    @Override
    public long getPeekPosition() {
        return this.position + (long)this.peekBufferPosition;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getLength() {
        return this.streamLength;
    }

    private void ensureSpaceForPeek(int n) {
        int n2 = this.peekBufferPosition + n;
        if (n2 > this.peekBuffer.length) {
            this.peekBuffer = Arrays.copyOf(this.peekBuffer, Math.max(this.peekBuffer.length * 2, n2));
        }
    }

    private int skipFromPeekBuffer(int n) {
        int n2 = Math.min(this.peekBufferLength, n);
        this.updatePeekBuffer(n2);
        return n2;
    }

    private int readFromPeekBuffer(byte[] byArray, int n, int n2) {
        if (this.peekBufferLength == 0) {
            return 0;
        }
        int n3 = Math.min(this.peekBufferLength, n2);
        System.arraycopy(this.peekBuffer, 0, byArray, n, n3);
        this.updatePeekBuffer(n3);
        return n3;
    }

    private void updatePeekBuffer(int n) {
        this.peekBufferLength -= n;
        this.peekBufferPosition = 0;
        System.arraycopy(this.peekBuffer, n, this.peekBuffer, 0, this.peekBufferLength);
    }

    private int readFromDataSource(byte[] byArray, int n, int n2, int n3, boolean bl) throws InterruptedException, IOException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int n4 = this.dataSource.read(byArray, n + n3, n2 - n3);
        if (n4 == -1) {
            if (n3 == 0 && bl) {
                return -1;
            }
            throw new EOFException();
        }
        return n3 + n4;
    }

    private void commitBytesRead(int n) {
        if (n != -1) {
            this.position += (long)n;
        }
    }
}

