/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.drm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaDrm;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.KeysExpiredException;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.exoplayer.drm.UnsupportedDrmException;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.util.Util;
import java.util.HashMap;
import java.util.UUID;

@TargetApi(value=18)
public class StreamingDrmSessionManager
implements DrmSessionManager {
    public static final UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);
    public static final UUID PLAYREADY_UUID = new UUID(-7348484286925749626L, -6083546864340672619L);
    public static final String PLAYREADY_CUSTOM_DATA_KEY = "PRCustomData";
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final MediaDrm mediaDrm;
    private final HashMap<String, String> optionalKeyRequestParameters;
    final MediaDrmHandler mediaDrmHandler;
    final MediaDrmCallback callback;
    final PostResponseHandler postResponseHandler;
    final UUID uuid;
    private HandlerThread requestHandlerThread;
    private Handler postRequestHandler;
    private int openCount;
    private boolean provisioningInProgress;
    private int state;
    private MediaCrypto mediaCrypto;
    private Exception lastException;
    private DrmInitData.SchemeInitData schemeInitData;
    private byte[] sessionId;

    public static StreamingDrmSessionManager newWidevineInstance(Looper looper, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, EventListener eventListener) throws UnsupportedDrmException {
        return new StreamingDrmSessionManager(WIDEVINE_UUID, looper, mediaDrmCallback, hashMap, handler, eventListener);
    }

    public static StreamingDrmSessionManager newPlayReadyInstance(Looper looper, MediaDrmCallback mediaDrmCallback, String string, Handler handler, EventListener eventListener) throws UnsupportedDrmException {
        HashMap<String, String> hashMap;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            hashMap = new HashMap<String, String>();
            hashMap.put(PLAYREADY_CUSTOM_DATA_KEY, string);
        } else {
            hashMap = null;
        }
        return new StreamingDrmSessionManager(PLAYREADY_UUID, looper, mediaDrmCallback, hashMap, handler, eventListener);
    }

    public StreamingDrmSessionManager(UUID uUID, Looper looper, MediaDrmCallback mediaDrmCallback, HashMap<String, String> hashMap, Handler handler, EventListener eventListener) throws UnsupportedDrmException {
        this.uuid = uUID;
        this.callback = mediaDrmCallback;
        this.optionalKeyRequestParameters = hashMap;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        try {
            this.mediaDrm = new MediaDrm(uUID);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            throw new UnsupportedDrmException(1, (Exception)((Object)unsupportedSchemeException));
        }
        catch (Exception exception) {
            throw new UnsupportedDrmException(2, exception);
        }
        this.mediaDrm.setOnEventListener((MediaDrm.OnEventListener)new MediaDrmEventListener());
        this.mediaDrmHandler = new MediaDrmHandler(looper);
        this.postResponseHandler = new PostResponseHandler(looper);
        this.state = 1;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final MediaCrypto getMediaCrypto() {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto;
    }

    @Override
    public boolean requiresSecureDecoderComponent(String string) {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto.requiresSecureDecoderComponent(string);
    }

    @Override
    public final Exception getError() {
        return this.state == 0 ? this.lastException : null;
    }

    public final String getPropertyString(String string) {
        return this.mediaDrm.getPropertyString(string);
    }

    public final void setPropertyString(String string, String string2) {
        this.mediaDrm.setPropertyString(string, string2);
    }

    public final byte[] getPropertyByteArray(String string) {
        return this.mediaDrm.getPropertyByteArray(string);
    }

    public final void setPropertyByteArray(String string, byte[] byArray) {
        this.mediaDrm.setPropertyByteArray(string, byArray);
    }

    @Override
    public void open(DrmInitData drmInitData) {
        if (++this.openCount != 1) {
            return;
        }
        if (this.postRequestHandler == null) {
            this.requestHandlerThread = new HandlerThread("DrmRequestHandler");
            this.requestHandlerThread.start();
            this.postRequestHandler = new PostRequestHandler(this.requestHandlerThread.getLooper());
        }
        if (this.schemeInitData == null) {
            byte[] byArray;
            this.schemeInitData = drmInitData.get(this.uuid);
            if (this.schemeInitData == null) {
                this.onError(new IllegalStateException("Media does not support uuid: " + this.uuid));
                return;
            }
            if (Util.SDK_INT < 21 && (byArray = PsshAtomUtil.parseSchemeSpecificData(this.schemeInitData.data, WIDEVINE_UUID)) != null) {
                this.schemeInitData = new DrmInitData.SchemeInitData(this.schemeInitData.mimeType, byArray);
            }
        }
        this.state = 2;
        this.openInternal(true);
    }

    @Override
    public void close() {
        if (--this.openCount != 0) {
            return;
        }
        this.state = 1;
        this.provisioningInProgress = false;
        this.mediaDrmHandler.removeCallbacksAndMessages(null);
        this.postResponseHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler = null;
        this.requestHandlerThread.quit();
        this.requestHandlerThread = null;
        this.schemeInitData = null;
        this.mediaCrypto = null;
        this.lastException = null;
        if (this.sessionId != null) {
            this.mediaDrm.closeSession(this.sessionId);
            this.sessionId = null;
        }
    }

    private void openInternal(boolean bl) {
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaCrypto = new MediaCrypto(this.uuid, this.sessionId);
            this.state = 3;
            this.postKeyRequest();
        }
        catch (NotProvisionedException notProvisionedException) {
            if (bl) {
                this.postProvisionRequest();
            } else {
                this.onError((Exception)((Object)notProvisionedException));
            }
        }
        catch (Exception exception) {
            this.onError(exception);
        }
    }

    private void postProvisionRequest() {
        if (this.provisioningInProgress) {
            return;
        }
        this.provisioningInProgress = true;
        MediaDrm.ProvisionRequest provisionRequest = this.mediaDrm.getProvisionRequest();
        this.postRequestHandler.obtainMessage(0, (Object)provisionRequest).sendToTarget();
    }

    private void onProvisionResponse(Object object) {
        this.provisioningInProgress = false;
        if (this.state != 2 && this.state != 3 && this.state != 4) {
            return;
        }
        if (object instanceof Exception) {
            this.onError((Exception)object);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])object);
            if (this.state == 2) {
                this.openInternal(false);
            } else {
                this.postKeyRequest();
            }
        }
        catch (DeniedByServerException deniedByServerException) {
            this.onError((Exception)((Object)deniedByServerException));
        }
    }

    private void postKeyRequest() {
        try {
            MediaDrm.KeyRequest keyRequest = this.mediaDrm.getKeyRequest(this.sessionId, this.schemeInitData.data, this.schemeInitData.mimeType, 1, this.optionalKeyRequestParameters);
            this.postRequestHandler.obtainMessage(1, (Object)keyRequest).sendToTarget();
        }
        catch (NotProvisionedException notProvisionedException) {
            this.onKeysError((Exception)((Object)notProvisionedException));
        }
    }

    private void onKeyResponse(Object object) {
        if (this.state != 3 && this.state != 4) {
            return;
        }
        if (object instanceof Exception) {
            this.onKeysError((Exception)object);
            return;
        }
        try {
            this.mediaDrm.provideKeyResponse(this.sessionId, (byte[])object);
            this.state = 4;
            if (this.eventHandler != null && this.eventListener != null) {
                this.eventHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        StreamingDrmSessionManager.this.eventListener.onDrmKeysLoaded();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.onKeysError(exception);
        }
    }

    private void onKeysError(Exception exception) {
        if (exception instanceof NotProvisionedException) {
            this.postProvisionRequest();
        } else {
            this.onError(exception);
        }
    }

    private void onError(final Exception exception) {
        this.lastException = exception;
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    StreamingDrmSessionManager.this.eventListener.onDrmSessionManagerError(exception);
                }
            });
        }
        if (this.state != 4) {
            this.state = 0;
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostRequestHandler
    extends Handler {
        public PostRequestHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            Object object;
            try {
                switch (message.what) {
                    case 0: {
                        object = StreamingDrmSessionManager.this.callback.executeProvisionRequest(StreamingDrmSessionManager.this.uuid, (MediaDrm.ProvisionRequest)message.obj);
                        break;
                    }
                    case 1: {
                        object = StreamingDrmSessionManager.this.callback.executeKeyRequest(StreamingDrmSessionManager.this.uuid, (MediaDrm.KeyRequest)message.obj);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception exception) {
                object = exception;
            }
            StreamingDrmSessionManager.this.postResponseHandler.obtainMessage(message.what, object).sendToTarget();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostResponseHandler
    extends Handler {
        public PostResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    StreamingDrmSessionManager.this.onProvisionResponse(message.obj);
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.onKeyResponse(message.obj);
                    return;
                }
            }
        }
    }

    private class MediaDrmEventListener
    implements MediaDrm.OnEventListener {
        private MediaDrmEventListener() {
        }

        public void onEvent(MediaDrm mediaDrm, byte[] byArray, int n, int n2, byte[] byArray2) {
            StreamingDrmSessionManager.this.mediaDrmHandler.sendEmptyMessage(n);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (StreamingDrmSessionManager.this.openCount == 0 || StreamingDrmSessionManager.this.state != 3 && StreamingDrmSessionManager.this.state != 4) {
                return;
            }
            switch (message.what) {
                case 2: {
                    StreamingDrmSessionManager.this.postKeyRequest();
                    return;
                }
                case 3: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.onError(new KeysExpiredException());
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.postProvisionRequest();
                    return;
                }
            }
        }
    }

    public static interface EventListener {
        public void onDrmKeysLoaded();

        public void onDrmSessionManagerError(Exception var1);
    }
}

