/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.UriUtil;

public final class RangedUri {
    public final long start;
    public final long length;
    private final String baseUri;
    private final String referenceUri;
    private int hashCode;

    public RangedUri(String string, String string2, long l, long l2) {
        Assertions.checkArgument(string != null || string2 != null);
        this.baseUri = string;
        this.referenceUri = string2;
        this.start = l;
        this.length = l2;
    }

    public Uri getUri() {
        return UriUtil.resolveToUri(this.baseUri, this.referenceUri);
    }

    public String getUriString() {
        return UriUtil.resolve(this.baseUri, this.referenceUri);
    }

    public RangedUri attemptMerge(RangedUri rangedUri) {
        if (rangedUri == null || !this.getUriString().equals(rangedUri.getUriString())) {
            return null;
        }
        if (this.length != -1L && this.start + this.length == rangedUri.start) {
            return new RangedUri(this.baseUri, this.referenceUri, this.start, rangedUri.length == -1L ? -1L : this.length + rangedUri.length);
        }
        if (rangedUri.length != -1L && rangedUri.start + rangedUri.length == this.start) {
            return new RangedUri(this.baseUri, this.referenceUri, rangedUri.start, this.length == -1L ? -1L : rangedUri.length + this.length);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 31 * n + (int)this.start;
            n = 31 * n + (int)this.length;
            this.hashCode = n = 31 * n + this.getUriString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RangedUri rangedUri = (RangedUri)object;
        return this.start == rangedUri.start && this.length == rangedUri.length && this.getUriString().equals(rangedUri.getUriString());
    }
}

