/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import android.content.Context;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.dash.DashTrackSelector;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class DefaultDashTrackSelector
implements DashTrackSelector {
    private final int adaptationSetType;
    private final Context context;
    private final boolean filterVideoRepresentations;
    private final boolean filterProtectedHdContent;

    public static DefaultDashTrackSelector newVideoInstance(Context context, boolean bl, boolean bl2) {
        return new DefaultDashTrackSelector(0, context, bl, bl2);
    }

    public static DefaultDashTrackSelector newAudioInstance() {
        return new DefaultDashTrackSelector(1, null, false, false);
    }

    public static DefaultDashTrackSelector newTextInstance() {
        return new DefaultDashTrackSelector(2, null, false, false);
    }

    private DefaultDashTrackSelector(int n, Context context, boolean bl, boolean bl2) {
        this.adaptationSetType = n;
        this.context = context;
        this.filterVideoRepresentations = bl;
        this.filterProtectedHdContent = bl2;
    }

    @Override
    public void selectTracks(MediaPresentationDescription mediaPresentationDescription, int n, DashTrackSelector.Output output) throws IOException {
        Period period = mediaPresentationDescription.getPeriod(n);
        for (int i = 0; i < period.adaptationSets.size(); ++i) {
            AdaptationSet adaptationSet = period.adaptationSets.get(i);
            if (adaptationSet.type != this.adaptationSetType) continue;
            if (this.adaptationSetType == 0) {
                int[] nArray = this.filterVideoRepresentations ? VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay(this.context, adaptationSet.representations, null, this.filterProtectedHdContent && adaptationSet.hasContentProtection()) : Util.firstIntegersArray(adaptationSet.representations.size());
                int n2 = nArray.length;
                if (n2 > 1) {
                    output.adaptiveTrack(mediaPresentationDescription, n, i, nArray);
                }
                for (int j = 0; j < n2; ++j) {
                    output.fixedTrack(mediaPresentationDescription, n, i, nArray[j]);
                }
                continue;
            }
            for (int j = 0; j < adaptationSet.representations.size(); ++j) {
                output.fixedTrack(mediaPresentationDescription, n, i, j);
            }
        }
    }
}

