/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.chunk.BaseChunkSampleSourceEventListener;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.extractor.DefaultTrackOutput;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ChunkSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final int STATE_IDLE = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_ENABLED = 3;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private final int eventSourceId;
    private final LoadControl loadControl;
    private final ChunkSource chunkSource;
    private final ChunkOperationHolder currentLoadableHolder;
    private final LinkedList<BaseMediaChunk> mediaChunks;
    private final List<BaseMediaChunk> readOnlyMediaChunks;
    private final DefaultTrackOutput sampleQueue;
    private final int bufferSizeContribution;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final int minLoadableRetryCount;
    private int state;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private long lastPerformedBufferOperation;
    private boolean pendingDiscontinuity;
    private Loader loader;
    private boolean loadingFinished;
    private IOException currentLoadableException;
    private int enabledTrackCount;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private long currentLoadStartTimeMs;
    private MediaFormat downstreamMediaFormat;
    private Format downstreamFormat;

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int n) {
        this(chunkSource, loadControl, n, null, null, 0);
    }

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int n, Handler handler, EventListener eventListener, int n2) {
        this(chunkSource, loadControl, n, handler, eventListener, n2, 3);
    }

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int n, Handler handler, EventListener eventListener, int n2, int n3) {
        this.chunkSource = chunkSource;
        this.loadControl = loadControl;
        this.bufferSizeContribution = n;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.eventSourceId = n2;
        this.minLoadableRetryCount = n3;
        this.currentLoadableHolder = new ChunkOperationHolder();
        this.mediaChunks = new LinkedList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.sampleQueue = new DefaultTrackOutput(loadControl.getAllocator());
        this.state = 0;
        this.pendingResetPositionUs = Long.MIN_VALUE;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        Assertions.checkState(this.state == 0);
        this.state = 1;
        return this;
    }

    @Override
    public boolean prepare(long l) {
        Assertions.checkState(this.state == 1 || this.state == 2);
        if (this.state == 2) {
            return true;
        }
        if (!this.chunkSource.prepare()) {
            return false;
        }
        if (this.chunkSource.getTrackCount() > 0) {
            this.loader = new Loader("Loader:" + this.chunkSource.getFormat((int)0).mimeType);
        }
        this.state = 2;
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.state == 2 || this.state == 3);
        return this.chunkSource.getTrackCount();
    }

    @Override
    public MediaFormat getFormat(int n) {
        Assertions.checkState(this.state == 2 || this.state == 3);
        return this.chunkSource.getFormat(n);
    }

    @Override
    public void enable(int n, long l) {
        Assertions.checkState(this.state == 2);
        Assertions.checkState(this.enabledTrackCount++ == 0);
        this.state = 3;
        this.chunkSource.enable(n);
        this.loadControl.register(this, this.bufferSizeContribution);
        this.downstreamFormat = null;
        this.downstreamMediaFormat = null;
        this.downstreamPositionUs = l;
        this.lastSeekPositionUs = l;
        this.pendingDiscontinuity = false;
        this.restartFrom(l);
    }

    @Override
    public void disable(int n) {
        Assertions.checkState(this.state == 3);
        Assertions.checkState(--this.enabledTrackCount == 0);
        this.state = 2;
        try {
            this.chunkSource.disable(this.mediaChunks);
        }
        finally {
            this.loadControl.unregister(this);
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.sampleQueue.clear();
                this.mediaChunks.clear();
                this.clearCurrentLoadable();
                this.loadControl.trimAllocator();
            }
        }
    }

    @Override
    public boolean continueBuffering(int n, long l) {
        Assertions.checkState(this.state == 3);
        this.downstreamPositionUs = l;
        this.chunkSource.continueBuffering(l);
        this.updateLoadControl();
        return this.loadingFinished || !this.sampleQueue.isEmpty();
    }

    @Override
    public long readDiscontinuity(int n) {
        if (this.pendingDiscontinuity) {
            this.pendingDiscontinuity = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int n, long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        MediaFormat mediaFormat;
        Assertions.checkState(this.state == 3);
        this.downstreamPositionUs = l;
        if (this.pendingDiscontinuity || this.isPendingReset()) {
            return -2;
        }
        boolean bl = !this.sampleQueue.isEmpty();
        BaseMediaChunk baseMediaChunk = this.mediaChunks.getFirst();
        while (bl && this.mediaChunks.size() > 1 && this.mediaChunks.get(1).getFirstSampleIndex() <= this.sampleQueue.getReadIndex()) {
            this.mediaChunks.removeFirst();
            baseMediaChunk = this.mediaChunks.getFirst();
        }
        if (this.downstreamFormat == null || !this.downstreamFormat.equals(baseMediaChunk.format)) {
            this.notifyDownstreamFormatChanged(baseMediaChunk.format, baseMediaChunk.trigger, baseMediaChunk.startTimeUs);
            this.downstreamFormat = baseMediaChunk.format;
        }
        if ((bl || baseMediaChunk.isMediaFormatFinal) && !(mediaFormat = baseMediaChunk.getMediaFormat()).equals(this.downstreamMediaFormat)) {
            mediaFormatHolder.format = mediaFormat;
            mediaFormatHolder.drmInitData = baseMediaChunk.getDrmInitData();
            this.downstreamMediaFormat = mediaFormat;
            return -4;
        }
        if (!bl) {
            if (this.loadingFinished) {
                return -1;
            }
            return -2;
        }
        if (this.sampleQueue.getSample(sampleHolder)) {
            boolean bl2 = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (bl2 ? 0x8000000 : 0);
            this.onSampleRead(baseMediaChunk, sampleHolder);
            return -3;
        }
        return -2;
    }

    @Override
    public void seekToUs(long l) {
        boolean bl;
        Assertions.checkState(this.state == 3);
        long l2 = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = l;
        this.lastSeekPositionUs = l;
        if (l2 == l) {
            return;
        }
        boolean bl2 = bl = !this.isPendingReset() && this.sampleQueue.skipToKeyframeBefore(l);
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = !this.sampleQueue.isEmpty();
            while (bl3 && this.mediaChunks.size() > 1 && this.mediaChunks.get(1).getFirstSampleIndex() <= this.sampleQueue.getReadIndex()) {
                this.mediaChunks.removeFirst();
            }
        } else {
            this.restartFrom(l);
        }
        this.pendingDiscontinuity = true;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
        if (this.currentLoadableHolder.chunk == null) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.state == 3);
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.loadingFinished) {
            return -3L;
        }
        long l = this.sampleQueue.getLargestParsedTimestampUs();
        return l == Long.MIN_VALUE ? this.downstreamPositionUs : l;
    }

    @Override
    public void release() {
        Assertions.checkState(this.state != 3);
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.state = 0;
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        long l = SystemClock.elapsedRealtime();
        long l2 = l - this.currentLoadStartTimeMs;
        Chunk chunk = this.currentLoadableHolder.chunk;
        this.chunkSource.onChunkLoadCompleted(chunk);
        if (this.isMediaChunk(chunk)) {
            BaseMediaChunk baseMediaChunk = (BaseMediaChunk)chunk;
            this.notifyLoadCompleted(chunk.bytesLoaded(), baseMediaChunk.type, baseMediaChunk.trigger, baseMediaChunk.format, baseMediaChunk.startTimeUs, baseMediaChunk.endTimeUs, l, l2);
        } else {
            this.notifyLoadCompleted(chunk.bytesLoaded(), chunk.type, chunk.trigger, chunk.format, -1L, -1L, l, l2);
        }
        this.clearCurrentLoadable();
        this.updateLoadControl();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        Chunk chunk = this.currentLoadableHolder.chunk;
        this.notifyLoadCanceled(chunk.bytesLoaded());
        this.clearCurrentLoadable();
        if (this.state == 3) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.sampleQueue.clear();
            this.mediaChunks.clear();
            this.clearCurrentLoadable();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        this.currentLoadableException = iOException;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyLoadError(iOException);
        this.chunkSource.onChunkLoadError(this.currentLoadableHolder.chunk, iOException);
        this.updateLoadControl();
    }

    protected void onSampleRead(MediaChunk mediaChunk, SampleHolder sampleHolder) {
    }

    private void restartFrom(long l) {
        this.pendingResetPositionUs = l;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.sampleQueue.clear();
            this.mediaChunks.clear();
            this.clearCurrentLoadable();
            this.updateLoadControl();
        }
    }

    private void clearCurrentLoadable() {
        this.currentLoadableHolder.chunk = null;
        this.clearCurrentLoadableException();
    }

    private void clearCurrentLoadableException() {
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private void updateLoadControl() {
        boolean bl;
        boolean bl2;
        long l = SystemClock.elapsedRealtime();
        long l2 = this.getNextLoadPositionUs();
        boolean bl3 = this.currentLoadableException != null;
        boolean bl4 = bl2 = this.loader.isLoading() || bl3;
        if (!bl2 && (this.currentLoadableHolder.chunk == null && l2 != -1L || l - this.lastPerformedBufferOperation > 2000L)) {
            this.lastPerformedBufferOperation = l;
            this.doChunkOperation();
            bl = this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            if (this.currentLoadableHolder.chunk == null) {
                l2 = -1L;
            } else if (bl) {
                l2 = this.getNextLoadPositionUs();
            }
        }
        bl = this.loadControl.update(this, this.downstreamPositionUs, l2, bl2);
        if (bl3) {
            long l3 = l - this.currentLoadableExceptionTimestamp;
            if (l3 >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.resumeFromBackOff();
            }
            return;
        }
        if (!this.loader.isLoading() && bl) {
            this.maybeStartLoading();
        }
    }

    private long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? -1L : this.mediaChunks.getLast().endTimeUs;
    }

    private void resumeFromBackOff() {
        this.currentLoadableException = null;
        Chunk chunk = this.currentLoadableHolder.chunk;
        if (!this.isMediaChunk(chunk)) {
            this.doChunkOperation();
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            if (this.currentLoadableHolder.chunk == chunk) {
                this.loader.startLoading(chunk, this);
            } else {
                this.notifyLoadCanceled(chunk.bytesLoaded());
                this.maybeStartLoading();
            }
            return;
        }
        if (chunk == this.mediaChunks.getFirst()) {
            this.loader.startLoading(chunk, this);
            return;
        }
        BaseMediaChunk baseMediaChunk = this.mediaChunks.removeLast();
        Assertions.checkState(chunk == baseMediaChunk);
        this.doChunkOperation();
        this.mediaChunks.add(baseMediaChunk);
        if (this.currentLoadableHolder.chunk == chunk) {
            this.loader.startLoading(chunk, this);
        } else {
            this.notifyLoadCanceled(chunk.bytesLoaded());
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            this.clearCurrentLoadableException();
            this.maybeStartLoading();
        }
    }

    private void maybeStartLoading() {
        Chunk chunk = this.currentLoadableHolder.chunk;
        if (chunk == null) {
            return;
        }
        this.currentLoadStartTimeMs = SystemClock.elapsedRealtime();
        if (this.isMediaChunk(chunk)) {
            BaseMediaChunk baseMediaChunk = (BaseMediaChunk)chunk;
            baseMediaChunk.init(this.sampleQueue);
            this.mediaChunks.add(baseMediaChunk);
            if (this.isPendingReset()) {
                this.pendingResetPositionUs = Long.MIN_VALUE;
            }
            this.notifyLoadStarted(baseMediaChunk.dataSpec.length, baseMediaChunk.type, baseMediaChunk.trigger, baseMediaChunk.format, baseMediaChunk.startTimeUs, baseMediaChunk.endTimeUs);
        } else {
            this.notifyLoadStarted(chunk.dataSpec.length, chunk.type, chunk.trigger, chunk.format, -1L, -1L);
        }
        this.loader.startLoading(chunk, this);
    }

    private void doChunkOperation() {
        this.currentLoadableHolder.endOfStream = false;
        this.currentLoadableHolder.queueSize = this.readOnlyMediaChunks.size();
        this.chunkSource.getChunkOperation(this.readOnlyMediaChunks, this.pendingResetPositionUs != Long.MIN_VALUE ? this.pendingResetPositionUs : this.downstreamPositionUs, this.currentLoadableHolder);
        this.loadingFinished = this.currentLoadableHolder.endOfStream;
    }

    private boolean discardUpstreamMediaChunks(int n) {
        if (this.mediaChunks.size() <= n) {
            return false;
        }
        long l = 0L;
        long l2 = this.mediaChunks.getLast().endTimeUs;
        BaseMediaChunk baseMediaChunk = null;
        while (this.mediaChunks.size() > n) {
            baseMediaChunk = this.mediaChunks.removeLast();
            l = baseMediaChunk.startTimeUs;
            this.loadingFinished = false;
        }
        this.sampleQueue.discardUpstreamSamples(baseMediaChunk.getFirstSampleIndex());
        this.notifyUpstreamDiscarded(l, l2);
        return true;
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof BaseMediaChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private long getRetryDelayMillis(long l) {
        return Math.min((l - 1L) * 1000L, 5000L);
    }

    protected final long usToMs(long l) {
        return l / 1000L;
    }

    private void notifyLoadStarted(final long l, final int n, final int n2, final Format format, final long l2, final long l3) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadStarted(ChunkSampleSource.this.eventSourceId, l, n, n2, format, ChunkSampleSource.this.usToMs(l2), ChunkSampleSource.this.usToMs(l3));
                }
            });
        }
    }

    private void notifyLoadCompleted(final long l, final int n, final int n2, final Format format, final long l2, final long l3, final long l4, final long l5) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCompleted(ChunkSampleSource.this.eventSourceId, l, n, n2, format, ChunkSampleSource.this.usToMs(l2), ChunkSampleSource.this.usToMs(l3), l4, l5);
                }
            });
        }
    }

    private void notifyLoadCanceled(final long l) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCanceled(ChunkSampleSource.this.eventSourceId, l);
                }
            });
        }
    }

    private void notifyLoadError(final IOException iOException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadError(ChunkSampleSource.this.eventSourceId, iOException);
                }
            });
        }
    }

    private void notifyUpstreamDiscarded(final long l, final long l2) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onUpstreamDiscarded(ChunkSampleSource.this.eventSourceId, ChunkSampleSource.this.usToMs(l), ChunkSampleSource.this.usToMs(l2));
                }
            });
        }
    }

    private void notifyDownstreamFormatChanged(final Format format, final int n, final long l) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onDownstreamFormatChanged(ChunkSampleSource.this.eventSourceId, format, n, ChunkSampleSource.this.usToMs(l));
                }
            });
        }
    }

    public static interface EventListener
    extends BaseChunkSampleSourceEventListener {
    }
}

