/*
 * Decompiled with CFR 0.152.
 */
package com.vcc.playerwrappersdk.controllers;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.vcc.playerwrappersdk.a.c;
import com.vcc.playerwrappersdk.a.e;
import com.vcc.playerwrappersdk.a.f;
import com.vcc.playerwrappersdk.controllers.APITransaction;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PlayerController
implements Parcelable,
PlaybackControlLayer.FullscreenCallback,
PlaybackControlLayer.PlayCallback {
    public static final String TAG = "Player sdk: ";
    private static final Object a = new Object();
    public static final int STATE_IDLE = 1;
    public static final int STATE_PREPARING = 2;
    public static final int STATE_BUFFERING = 3;
    public static final int STATE_READY = 4;
    public static final int STATE_ENDED = 5;
    public static final int TIME_DEFAULT = 5000;
    private com.vcc.playerwrappersdk.controllers.b b;
    private FrameLayout c;
    private WeakReference<OnPlayerCallback> d;
    private Video e;
    private String f;
    private boolean g;
    private int h = -1;
    private ProgressBar i;
    private boolean j = false;
    private b k;
    private boolean l;
    private boolean m;
    private long n = 0L;
    private boolean o = false;
    private int p;
    private TimerTask q;
    private Timer r;
    private Handler s = new Handler();
    private boolean t = false;
    private Handler u = new Handler(Looper.getMainLooper());
    public static final Parcelable.Creator<PlayerController> CREATOR = new Parcelable.Creator<PlayerController>(){

        public PlayerController a(Parcel parcel) {
            return new PlayerController(parcel);
        }

        public PlayerController[] a(int n) {
            return new PlayerController[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };
    public static final String TIME_PROGRESS = "time_progress_skin";
    public static final String BUFFER_PROGRESS = "buffer_progress_skin";
    public static final String CURRENT_TIME = "current_time_skin";
    public static final String DURATION_VIDEO = "duration_video_skin";
    public static final String SHOW_CONTROL = "show_control_skin";
    public static final String LIVE_VIDEO = "live_video_skin";
    public static final String LOADING_VIDEO = "loading_video_skin";
    public static final String RELEASE_SKIN = "release_sdk_skin";

    protected PlayerController(Parcel parcel) {
        this.f = parcel.readString();
        this.g = parcel.readByte() != 0;
        this.h = parcel.readInt();
        this.j = parcel.readByte() != 0;
        this.l = parcel.readByte() != 0;
        this.m = parcel.readByte() != 0;
        this.n = parcel.readLong();
        this.o = parcel.readByte() != 0;
        this.p = parcel.readInt();
        this.t = parcel.readByte() != 0;
    }

    private Date a(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public boolean setContext(Context context) {
        try {
            com.vcc.playerwrappersdk.controllers.a.a().b(context);
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.a(exception.getMessage());
            return false;
        }
    }

    public PlayerController(Context context, String string2, String string3, String string4, OnPlayerCallback onPlayerCallback) {
        com.vcc.playerwrappersdk.controllers.a.a(context);
        this.setOnPlayerCallback(onPlayerCallback);
        com.vcc.playerwrappersdk.controllers.a.a().a(string2);
        com.vcc.playerwrappersdk.controllers.a.a().b(string3);
        com.vcc.playerwrappersdk.controllers.a.a().c(string4);
        if (!this.b("android.permission.INTERNET")) {
            if (onPlayerCallback == null) {
                Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            } else {
                onPlayerCallback.onError("You not permission internet. Please check again!");
            }
        } else {
            Call<f> call;
            Object object;
            if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                this.h = -1;
                if (onPlayerCallback == null) {
                    Log.e((String)TAG, (String)"AppKey, Secret Key must not empty! OnPlayerCallback cannot null");
                } else {
                    onPlayerCallback.onError("AppKey, Secret Key must not empty!");
                }
                return;
            }
            String string5 = "";
            Date date = new Date();
            final Date date2 = this.a(date, 1);
            try {
                object = new HashMap<String, String>();
                object.put("appkey", this.getAppkey());
                object.put("player", this.getPlayerId());
                object.put("platform", "android");
                object.put("package_name", this.getActivity().getPackageName());
                call = string2 + "-" + string3;
                string5 = Jwts.builder().setClaims(object).setHeaderParam("typ", (Object)"JWT").setIssuedAt(date).setExpiration(date2).signWith(SignatureAlgorithm.HS256, call.getBytes()).compact();
            }
            catch (Exception exception) {
                this.a();
                return;
            }
            object = "https://adminplayer.sohatv.vn/secure/verify/" + string2 + "/" + this.getPlayerId() + "/" + string5;
            call = APITransaction.b().verifySDK((String)object);
            Callback<f> callback = new Callback<f>(){

                public void onResponse(Call<f> call, Response<f> response) {
                    if (response == null || response.body() == null) {
                        PlayerController.this.a();
                        return;
                    }
                    f f2 = (f)response.body();
                    if (f2.a().equals("200")) {
                        String string2 = PlayerController.this.a(String.valueOf(date2.getTime() / 1000L));
                        String string3 = f2.b();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3) && string2.equals(string3)) {
                            PlayerController.this.h = 1;
                            if (PlayerController.this.j) {
                                PlayerController.this.c();
                            }
                            return;
                        }
                        PlayerController.this.a();
                    }
                }

                public void onFailure(Call<f> call, Throwable throwable) {
                    PlayerController.this.a();
                }
            };
            call.enqueue((Callback)callback);
        }
    }

    private void a() {
        this.h = 0;
        if (this.getOnPlayerCallback() == null) {
            Log.e((String)TAG, (String)"You have not permission!");
        } else {
            this.getOnPlayerCallback().onError("You have not permission!");
        }
    }

    private String a(String string2) {
        String string3 = string2 + "-player-verified";
        String string4 = "MD5";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string3.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                String string5 = Integer.toHexString(0xFF & by);
                while (string5.length() < 2) {
                    string5 = "0" + string5;
                }
                stringBuilder.append(string5);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void setLogoPlayer(Drawable drawable2) {
        try {
            this.b.a(drawable2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
        }
    }

    public void setLogoPlayer(int n) {
        try {
            Drawable drawable2 = com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getDrawable(n);
            this.b.a(drawable2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
        }
    }

    public boolean addActionButton(Drawable drawable2, String string2, View.OnClickListener onClickListener) {
        try {
            this.b.a(drawable2, string2, onClickListener);
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
            return false;
        }
    }

    public boolean addActionButtonRes(int n, int n2, View.OnClickListener onClickListener) {
        try {
            this.b.a(com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getDrawable(n), com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getString(n2), onClickListener);
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
            return false;
        }
    }

    public void releasePlayer() {
        if (this.b != null) {
            this.b.d();
        }
    }

    private com.vcc.playerwrappersdk.controllers.b b() {
        return this.b;
    }

    public boolean playVideo() {
        if (this.h == -1 || this.h == 0) {
            try {
                this.b.b();
            }
            catch (Exception exception) {
                com.vcc.playerwrappersdk.a.d(TAG, "Failed " + exception.getMessage());
            }
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.b.c();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean pauseVideo() {
        if (this.h == -1 || this.h == 0) {
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.b.b();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean resumeVideo() {
        if (this.h == -1 || this.h == 0) {
            try {
                this.b.b();
            }
            catch (Exception exception) {
                com.vcc.playerwrappersdk.a.d(TAG, "Failed " + exception.getMessage());
            }
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.b.c();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean stopVideo() {
        try {
            this.b.b();
            this.b.d();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public int getCurrentPosition() {
        if (this.b() != null) {
            return this.b().g();
        }
        return -1;
    }

    public int getLengthVideo() {
        if (this.b() != null) {
            return this.b().h();
        }
        return -1;
    }

    public void seekTo(int n) {
        if (this.b() != null) {
            this.b().a(n);
        }
    }

    public boolean isPlaying() {
        return this.b() != null && this.b().j();
    }

    public void getTimeCurrentLive(final @NonNull OnCurrentTimeLiveCallback onCurrentTimeLiveCallback) {
        if (this.h == -1 || this.h == 0) {
            if (this.b != null) {
                this.b.b();
            }
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"You have not permission!");
            return;
        }
        if (this.e == null || TextUtils.isEmpty((CharSequence)this.e.getUrl())) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Content url is invalid. Check again");
            return;
        }
        if (this.e.getVideoType() != Video.VideoType.HLS) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Video must live.");
            return;
        }
        String string2 = null;
        try {
            string2 = URLEncoder.encode(this.e.getUrl(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)TAG, (String)("Encode url failed: " + unsupportedEncodingException.getMessage()));
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Url invalid to get time live.");
            return;
        }
        Call<e> call = APITransaction.a().getTimeLive(string2);
        Callback<e> callback = new Callback<e>(){

            public void onResponse(Call<e> call, Response<e> response) {
                if (response == null || response.body() == null || ((e)response.body()).a() == null) {
                    onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
                    Log.e((String)PlayerController.TAG, (String)"Cannot get current time error response empty");
                    return;
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                try {
                    l = Long.parseLong(((e)response.body()).a().a());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                try {
                    l2 = Long.parseLong(((e)response.body()).a().b());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                try {
                    l3 = Long.parseLong(((e)response.body()).a().c());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                onCurrentTimeLiveCallback.onCurrentTime(true, l, l2, l3);
            }

            public void onFailure(Call<e> call, Throwable throwable) {
                onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
                Log.e((String)PlayerController.TAG, (String)"Cannot get current time error require api");
            }
        };
        call.enqueue((Callback)callback);
    }

    public boolean isMuted() {
        return this.b != null && this.b.k();
    }

    public boolean setMute(boolean bl) {
        return this.b != null && this.b.d(bl);
    }

    @Override
    public void onGoToFullscreen() {
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onFullScreen();
    }

    @Override
    public void onReturnFromFullscreen() {
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onNormalScreen();
    }

    @Override
    public void onPlay() {
        if (this.h == -1 || this.h == 0) {
            this.b.b();
            Log.e((String)TAG, (String)"You have not permission!");
            return;
        }
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onPlay();
    }

    private void c() {
        if (this.k != null && this.k.getStatus() == AsyncTask.Status.RUNNING) {
            this.k.cancel(true);
            this.k = null;
        }
        if (this.e == null) {
            if (this.getOnPlayerCallback() != null) {
                this.getOnPlayerCallback().onError("Video content url is not null!");
            }
            return;
        }
        this.k = new b(this.e.getUrl());
        this.k.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null});
    }

    private void d() {
        if (this.i != null) {
            this.i.setVisibility(8);
        }
        if (this.b != null) {
            this.b.d();
        }
        this.c.removeAllViews();
        this.b = new com.vcc.playerwrappersdk.controllers.b(com.vcc.playerwrappersdk.controllers.a.a().e(), this.c, this.e, this.f, this.m);
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback != null) {
            this.b.a(onPlayerCallback);
        }
        this.b.b(this.l);
        this.b.a(this.g);
        this.b.a(this);
        this.b.a(this);
    }

    public Video getVideoContentUrl() {
        return this.e;
    }

    public PlayerController setVideoContentUrl(Video video) {
        this.e = new Video(video.getUrl(), video.getVideoType(), video.getContentId());
        return this;
    }

    public String getVideoTitle() {
        return this.f;
    }

    public PlayerController setVideoTitle(String string2) {
        this.f = string2;
        return this;
    }

    public boolean isAutoPlay() {
        return this.g;
    }

    public PlayerController setAutoPlay(boolean bl) {
        this.g = bl;
        return this;
    }

    public void toggleFullscreen() {
        if (this.b() != null) {
            this.b().i();
        }
    }

    public void subcribleViewerNumber(int n) {
        if (n < 5000) {
            n = 5000;
        }
        this.setTimeInterval(n);
        if (this.e.getVideoType() == Video.VideoType.HLS) {
            this.e();
        } else if (this.e.getVideoType() == Video.VideoType.OTHER) {
            if (this.e.getUrl().endsWith(".m3u8")) {
                this.e();
            }
        } else if (this.getOnPlayerCallback() != null) {
            this.getOnPlayerCallback().onViewerNumber(this.e.getUrl(), false, "0", "Your video is not counter number viewer");
        }
    }

    public void unSubcribleViewerNumber() {
        this.p = 0;
        this.n = System.currentTimeMillis();
        this.o = true;
        if (this.r != null) {
            this.r.purge();
            this.r.cancel();
        }
        this.r = null;
        if (this.q != null) {
            this.q.cancel();
        }
        this.q = null;
        this.o = false;
        this.n = 0L;
        this.t = false;
    }

    private void e() {
        if (this.t) {
            return;
        }
        if (this.r == null) {
            this.r = new Timer();
        }
        if (this.q == null) {
            this.q = new TimerTask(){

                @Override
                public void run() {
                    PlayerController.this.s.post(new Runnable(){

                        @Override
                        public void run() {
                            PlayerController.this.a(PlayerController.this.p);
                        }
                    });
                }
            };
        }
        this.r.schedule(this.q, 0L, (long)this.p);
        this.t = true;
    }

    private void a(int n) {
        if (this.o) {
            return;
        }
        if (this.n == 0L || System.currentTimeMillis() - this.n > (long)n) {
            this.o = true;
            this.n = System.currentTimeMillis();
            com.vcc.playerwrappersdk.a.a("Start: " + this.n);
            this.requestViewNumber("", false);
        }
    }

    public void requestViewNumber(String string2, boolean bl) {
        block2: {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", (Object)(TextUtils.isEmpty((CharSequence)string2) ? this.e.getUrl() : string2));
                jSONObject.put("isVideoId", bl);
                this.a("GET_VIEW_NUMBER", jSONObject);
            }
            catch (JSONException jSONException) {
                if (this.getOnPlayerCallback() == null) break block2;
                this.getOnPlayerCallback().onViewerNumber(TextUtils.isEmpty((CharSequence)string2) ? this.e.getUrl() : string2, false, "0", "Exception when set data to get. Please try again!");
            }
        }
    }

    public OnPlayerCallback getOnPlayerCallback() {
        return this.d == null ? null : (OnPlayerCallback)this.d.get();
    }

    public PlayerController setOnPlayerCallback(OnPlayerCallback onPlayerCallback) {
        this.d = new WeakReference<OnPlayerCallback>(onPlayerCallback);
        if (this.b != null) {
            this.b.a(onPlayerCallback);
        }
        return this;
    }

    public FrameLayout getVideoPlayerContainer() {
        return this.c;
    }

    public PlayerController setVideoPlayerContainer(FrameLayout frameLayout) {
        this.c = frameLayout;
        if (this.i == null) {
            this.i = new ProgressBar(com.vcc.playerwrappersdk.controllers.a.a().e());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(100, 100);
            layoutParams.gravity = 17;
            this.c.addView((View)this.i, (ViewGroup.LayoutParams)layoutParams);
            this.i.setVisibility(0);
        } else {
            this.i.setVisibility(0);
        }
        return this;
    }

    public void showLoading() {
        if (this.i != null) {
            this.i.bringToFront();
            if (this.c != null) {
                this.c.bringChildToFront((View)this.i);
            }
            this.i.setVisibility(0);
        }
    }

    public void hideLoading() {
        if (this.i != null) {
            this.i.bringToFront();
            this.c.bringChildToFront((View)this.i);
            this.i.setVisibility(8);
        }
    }

    public PlayerController build() {
        this.j = true;
        if (this.h == -1 || this.h == 0) {
            Log.e((String)TAG, (String)"Waiting!");
            return this;
        }
        this.c();
        return this;
    }

    private boolean b(String string2) {
        return ContextCompat.checkSelfPermission((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (String)string2) == 0;
    }

    public PlayerController hideController(boolean bl) {
        this.l = bl;
        return this;
    }

    public PlayerController setFixedContent(boolean bl) {
        this.m = bl;
        if (this.b != null) {
            this.b.c(bl);
        }
        return this;
    }

    public Context getActivity() {
        return com.vcc.playerwrappersdk.controllers.a.a().e();
    }

    public void setAppkey(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().a(string2);
    }

    public String getAppkey() {
        return com.vcc.playerwrappersdk.controllers.a.a().f();
    }

    public void setSecretKey(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().b(string2);
    }

    public String getSecretKey() {
        return com.vcc.playerwrappersdk.controllers.a.a().g();
    }

    public void setTimeInterval(int n) {
        this.p = n;
    }

    public int getTimeInterval() {
        return this.p;
    }

    public String getPlayerId() {
        return com.vcc.playerwrappersdk.controllers.a.a().h();
    }

    public void setPlayerId(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().c(string2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.f);
        parcel.writeByte((byte)(this.g ? 1 : 0));
        parcel.writeInt(this.h);
        parcel.writeByte((byte)(this.j ? 1 : 0));
        parcel.writeByte((byte)(this.l ? 1 : 0));
        parcel.writeByte((byte)(this.m ? 1 : 0));
        parcel.writeLong(this.n);
        parcel.writeByte((byte)(this.o ? 1 : 0));
        parcel.writeInt(this.p);
        parcel.writeByte((byte)(this.t ? 1 : 0));
    }

    private void c(String string2) {
        new a().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{string2});
    }

    private void a(String string2, Object object) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("event", (Object)string2);
            jSONObject.put("value", object);
            com.vcc.playerwrappersdk.b.a.a().b(jSONObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Subscribe(threadMode=ThreadMode.BACKGROUND)
    public void onEvent(JSONObject jSONObject) {
        final com.vcc.playerwrappersdk.b.c c2 = new com.vcc.playerwrappersdk.b.c();
        final String string2 = c2.a("event", jSONObject);
        final Object object = c2.b("value", jSONObject);
        if (object == null) {
            return;
        }
        if (this.u == null) {
            this.u = new Handler(Looper.getMainLooper());
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                switch (string2) {
                    case "VIEW_NUMBER": {
                        if (!(object instanceof JSONObject)) break;
                        String string22 = c2.a("id", (JSONObject)object);
                        String string3 = c2.a("isVideoId", (JSONObject)object);
                        String string4 = c2.a("number", (JSONObject)object);
                        String string5 = c2.a("message", (JSONObject)object);
                        if (PlayerController.this.getOnPlayerCallback() == null) break;
                        PlayerController.this.getOnPlayerCallback().onViewerNumber(string22, string3.equals("true"), string4, string5);
                    }
                }
            }
        });
    }

    private class a
    extends AsyncTask<String, Void, String> {
        String a = this.a();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String a(String ... stringArray) {
            URL uRL;
            String string2 = stringArray[0];
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return string2 != null ? string2 : "";
            }
            com.vcc.playerwrappersdk.a.a(PlayerController.TAG, "Checking URL redirect:" + string2);
            int n = -1;
            HttpURLConnection httpURLConnection = null;
            String string3 = uRL.toString();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string3);
            try {
                do {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", this.a);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    n = httpURLConnection.getResponseCode();
                    if (n == 200) {
                        httpURLConnection.disconnect();
                        break;
                    }
                    string3 = httpURLConnection.getHeaderField("location");
                    httpURLConnection.disconnect();
                    if (!hashSet.add(string3)) {
                        Log.d((String)PlayerController.TAG, (String)"URL redirect cycle detected");
                        String string4 = "";
                        return string4;
                    }
                    uRL = new URL(string3);
                } while (n == 302 || n == 301 || n == 307 || n == 303);
            }
            catch (IOException iOException) {
                String string5 = string3 != null ? string3 : "";
                return string5;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            return string3;
        }

        protected void a(String string2) {
            com.vcc.playerwrappersdk.a.a(PlayerController.TAG, "Url response: " + string2);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                PlayerController.this.d();
                return;
            }
            this.b(string2);
        }

        private void b(String string2) {
            if (string2.equals("")) {
                Toast.makeText((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (CharSequence)"Cannot play this video!", (int)0).show();
                if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onError("Url video is empty!");
                }
                return;
            }
            PlayerController.this.e.setUrl(string2);
            PlayerController.this.d();
        }

        public String a() {
            String string2 = System.getProperty("http.agent");
            return string2;
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((String)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((String[])objectArray);
        }
    }

    private class b
    extends AsyncTask<Void, Void, Void> {
        private final String b;
        private int c = 1;
        private Activity d = null;

        b(String string2) {
            this.b = string2;
            this.d = com.vcc.playerwrappersdk.controllers.a.a().e() instanceof Activity ? (Activity)com.vcc.playerwrappersdk.controllers.a.a().e() : null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Void a(Void ... voidArray) {
            this.a();
            return null;
        }

        private void a() {
            String string2 = Settings.Secure.getString((ContentResolver)com.vcc.playerwrappersdk.controllers.a.a().e().getContentResolver(), (String)"android_id");
            if (this.b.equals("")) {
                return;
            }
            int n = this.b.lastIndexOf("/");
            String string3 = this.b.substring(0, n + 1);
            if (n + 1 == this.b.length() || TextUtils.isEmpty((CharSequence)string3) || this.b.equals(string3)) {
                PlayerController.this.c(this.b);
                return;
            }
            this.a(string3, string2);
        }

        private void a(String string2, String string3) {
            Call<c> call = APITransaction.b().getLinkPlayVideo(this.b, string3);
            call.enqueue((Callback)new Callback<c>(){

                public void onResponse(Call<c> call, Response<c> response) {
                    if (response == null || response.body() == null || ((c)response.body()).a() == null) {
                        if (PlayerController.this.i != null) {
                            PlayerController.this.i.setVisibility(8);
                        }
                        com.vcc.playerwrappersdk.a.d("PLAYER.VCC", "===============parse data error!!!===========\n");
                        PlayerController.this.c(b.this.b);
                        return;
                    }
                    c c2 = (c)response.body();
                    String string2 = c2.a().a();
                    if (Integer.parseInt(string2) == b.this.c) {
                        String string3 = c2.b().b();
                        String string4 = c2.b().a();
                        b.this.b(string4, string3);
                    } else {
                        if (PlayerController.this.i != null) {
                            PlayerController.this.i.setVisibility(8);
                        }
                        PlayerController.this.c(b.this.b);
                    }
                }

                public void onFailure(Call<c> call, Throwable throwable) {
                    com.vcc.playerwrappersdk.a.d("PLAYER.VCC", "" + throwable.getMessage());
                    if (PlayerController.this.i != null) {
                        PlayerController.this.i.setVisibility(8);
                    }
                    PlayerController.this.c(b.this.b);
                }
            });
        }

        private void b(String string2, String string3) {
            if (string2.equals("")) {
                Toast.makeText((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (CharSequence)"Cannot play this video!", (int)0).show();
                if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onError("Url video is empty!");
                }
                return;
            }
            this.a(string3);
            PlayerController.this.e.setUrl(string2);
            PlayerController.this.d();
        }

        private void a(String string2) {
            if (this.d == null) {
                return;
            }
            switch (string2) {
                case "2": {
                    this.d.setRequestedOrientation(7);
                    break;
                }
                case "1": {
                    this.d.setRequestedOrientation(6);
                    break;
                }
                default: {
                    this.d.setRequestedOrientation(4);
                }
            }
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    public static interface OnCurrentTimeLiveCallback {
        public void onCurrentTime(boolean var1, long var2, long var4, long var6);
    }

    public static interface OnPlayerCallback {
        public void onFullScreen();

        public void onNormalScreen();

        public void onPlay();

        public void onError(String var1);

        public void playState(int var1);

        public void videSizeChange(int var1, int var2, int var3, float var4);

        public void onPlayPressed();

        public void onPausePressed();

        public void onUpdateProgress(int var1, int var2);

        public void onBuffering(int var1);

        public void onShowHideControl(boolean var1);

        public void onViewerNumber(String var1, boolean var2, String var3, String var4);
    }
}

