/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.widget.FrameLayout;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.layeredvideo.Layer;
import com.google.android.libraries.mediaframework.layeredvideo.LayerManager;
import com.google.android.libraries.mediaframework.layeredvideo.VideoTextureView;
import com.vcc.playerwrappersdk.R;

public class VideoSurfaceLayer
implements Layer {
    private boolean autoplay;
    private LayerManager layerManager;
    private ExoplayerWrapper.PlaybackListener playbackListener = new ExoplayerWrapper.PlaybackListener(){

        @Override
        public void onStateChanged(boolean bl, int n) {
        }

        @Override
        public void onError(Exception exception) {
        }

        @Override
        public void onVideoSizeChanged(int n, int n2, int n3, float f2) {
            VideoSurfaceLayer.this.surfaceView.setVideoSize(n, n2);
            VideoSurfaceLayer.this.surfaceView.setVideoWidthHeightRatio(n2 == 0 ? 1.0f : (float)n * f2 / (float)n2);
        }
    };
    private VideoTextureView surfaceView;
    private FrameLayout view;
    private boolean fixedContent;
    private SurfaceTexture surfaceTexture;

    public VideoSurfaceLayer(boolean bl) {
        this.autoplay = bl;
    }

    @Override
    public FrameLayout createView(final LayerManager layerManager) {
        ExoplayerWrapper exoplayerWrapper;
        this.layerManager = layerManager;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)layerManager.getContext());
        this.view = (FrameLayout)layoutInflater.inflate(R.layout.video_surface_layer, null);
        layerManager.getExoplayerWrapper().addListener(this.playbackListener);
        this.surfaceView = (VideoTextureView)this.view.findViewById(R.id.surface_view);
        if (this.surfaceView != null) {
            this.surfaceView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
                    VideoSurfaceLayer.this.surfaceTexture = surfaceTexture;
                    ExoplayerWrapper exoplayerWrapper = layerManager.getExoplayerWrapper();
                    if (exoplayerWrapper != null) {
                        exoplayerWrapper.setSurface(new Surface(surfaceTexture));
                        if (exoplayerWrapper.getSurface().isValid() || exoplayerWrapper.getStateForTrackType(0) == -1) {
                            exoplayerWrapper.setPlayWhenReady(VideoSurfaceLayer.this.autoplay);
                        }
                    }
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                    VideoSurfaceLayer.this.surfaceTexture = null;
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
                }
            });
            this.surfaceView.setFixedContent(this.fixedContent);
            this.surfaceView.setLayoutContainer(layerManager.getContainer());
        }
        if ((exoplayerWrapper = layerManager.getExoplayerWrapper()) != null) {
            exoplayerWrapper.setPlayWhenReady(this.autoplay);
        }
        return this.view;
    }

    @Override
    public void onLayerDisplayed(LayerManager layerManager) {
    }

    public void moveSurfaceToBackground() {
    }

    public void moveSurfaceToForeground() {
    }

    public void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public void release() {
        ExoplayerWrapper exoplayerWrapper = this.layerManager.getExoplayerWrapper();
        if (exoplayerWrapper != null) {
            exoplayerWrapper.removeListener(this.playbackListener);
        }
    }

    public void hide() {
        this.surfaceView.setVisibility(4);
    }

    public void show() {
        this.surfaceView.setVisibility(0);
    }

    public void setFixedContent(boolean bl) {
        this.fixedContent = bl;
    }
}

