/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.widget.TextView;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.chunk.ChunkSampleSource;

class DebugTrackRenderer
extends TrackRenderer
implements Runnable {
    private final TextView textView;
    private final MediaCodecTrackRenderer renderer;
    private final ChunkSampleSource videoSampleSource;
    private volatile boolean pendingFailure;
    private volatile long currentPositionUs;

    public DebugTrackRenderer(TextView textView, MediaCodecTrackRenderer mediaCodecTrackRenderer) {
        this(textView, mediaCodecTrackRenderer, null);
    }

    public DebugTrackRenderer(TextView textView, MediaCodecTrackRenderer mediaCodecTrackRenderer, ChunkSampleSource chunkSampleSource) {
        this.textView = textView;
        this.renderer = mediaCodecTrackRenderer;
        this.videoSampleSource = chunkSampleSource;
    }

    public void injectFailure() {
        this.pendingFailure = true;
    }

    @Override
    protected boolean isEnded() {
        return true;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    @Override
    protected boolean doPrepare(long l) throws ExoPlaybackException {
        this.maybeFail();
        return true;
    }

    @Override
    protected void doSomeWork(long l, long l2) throws ExoPlaybackException {
        this.maybeFail();
        if (l < this.currentPositionUs || l > this.currentPositionUs + 1000000L) {
            this.currentPositionUs = l;
            this.textView.post((Runnable)this);
        }
    }

    @Override
    public void run() {
        this.textView.setText((CharSequence)this.getRenderString());
    }

    private String getRenderString() {
        return "ms(" + this.currentPositionUs / 1000L + "), " + this.getQualityString() + ", " + this.renderer.codecCounters.getDebugString();
    }

    private String getQualityString() {
        MediaFormat mediaFormat = this.videoSampleSource == null ? null : this.videoSampleSource.getFormat(0);
        return mediaFormat == null ? "null" : "height(" + mediaFormat.height + "), itag(" + mediaFormat.trackId + ")";
    }

    @Override
    protected long getDurationUs() {
        return -2L;
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected void seekTo(long l) {
        this.currentPositionUs = l;
    }

    private void maybeFail() throws ExoPlaybackException {
        if (this.pendingFailure) {
            this.pendingFailure = false;
            throw new ExoPlaybackException("fail() was called on DebugTrackRenderer");
        }
    }

    @Override
    protected void maybeThrowError() {
    }

    @Override
    protected MediaFormat getFormat(int n) {
        throw new IllegalStateException();
    }

    @Override
    protected int getTrackCount() {
        return 0;
    }
}

