/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import java.io.IOException;
import java.util.concurrent.CancellationException;

public class ManifestFetcher<T>
implements Loader.Callback {
    private final UriLoadable.Parser<T> parser;
    private final UriDataSource uriDataSource;
    private final Handler eventHandler;
    private final EventListener eventListener;
    volatile String manifestUri;
    private int enabledCount;
    private Loader loader;
    private UriLoadable<T> currentLoadable;
    private long currentLoadStartTimestamp;
    private int loadExceptionCount;
    private long loadExceptionTimestamp;
    private ManifestIOException loadException;
    private volatile T manifest;
    private volatile long manifestLoadStartTimestamp;
    private volatile long manifestLoadCompleteTimestamp;

    public ManifestFetcher(String string, UriDataSource uriDataSource, UriLoadable.Parser<T> parser) {
        this(string, uriDataSource, parser, null, null);
    }

    public ManifestFetcher(String string, UriDataSource uriDataSource, UriLoadable.Parser<T> parser, Handler handler, EventListener eventListener) {
        this.parser = parser;
        this.manifestUri = string;
        this.uriDataSource = uriDataSource;
        this.eventHandler = handler;
        this.eventListener = eventListener;
    }

    public void updateManifestUri(String string) {
        this.manifestUri = string;
    }

    public void singleLoad(Looper looper, ManifestCallback<T> manifestCallback) {
        SingleFetchHelper singleFetchHelper = new SingleFetchHelper(new UriLoadable<T>(this.manifestUri, this.uriDataSource, this.parser), looper, manifestCallback);
        singleFetchHelper.startLoading();
    }

    public T getManifest() {
        return this.manifest;
    }

    public long getManifestLoadStartTimestamp() {
        return this.manifestLoadStartTimestamp;
    }

    public long getManifestLoadCompleteTimestamp() {
        return this.manifestLoadCompleteTimestamp;
    }

    public void maybeThrowError() throws ManifestIOException {
        if (this.loadException == null || this.loadExceptionCount <= 1) {
            return;
        }
        throw this.loadException;
    }

    public void enable() {
        if (this.enabledCount++ == 0) {
            this.loadExceptionCount = 0;
            this.loadException = null;
        }
    }

    public void disable() {
        if (--this.enabledCount == 0 && this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
    }

    public void requestRefresh() {
        if (this.loadException != null && SystemClock.elapsedRealtime() < this.loadExceptionTimestamp + this.getRetryDelayMillis(this.loadExceptionCount)) {
            return;
        }
        if (this.loader == null) {
            this.loader = new Loader("manifestLoader");
        }
        if (!this.loader.isLoading()) {
            this.currentLoadable = new UriLoadable<T>(this.manifestUri, this.uriDataSource, this.parser);
            this.currentLoadStartTimestamp = SystemClock.elapsedRealtime();
            this.loader.startLoading(this.currentLoadable, this);
            this.notifyManifestRefreshStarted();
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        RedirectingManifest redirectingManifest;
        String string;
        if (this.currentLoadable != loadable) {
            return;
        }
        this.manifest = this.currentLoadable.getResult();
        this.manifestLoadStartTimestamp = this.currentLoadStartTimestamp;
        this.manifestLoadCompleteTimestamp = SystemClock.elapsedRealtime();
        this.loadExceptionCount = 0;
        this.loadException = null;
        if (this.manifest instanceof RedirectingManifest && !TextUtils.isEmpty((CharSequence)(string = (redirectingManifest = (RedirectingManifest)this.manifest).getNextManifestUri()))) {
            this.manifestUri = string;
        }
        this.notifyManifestRefreshed();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        if (this.currentLoadable != loadable) {
            return;
        }
        ++this.loadExceptionCount;
        this.loadExceptionTimestamp = SystemClock.elapsedRealtime();
        this.loadException = new ManifestIOException(iOException);
        this.notifyManifestError(this.loadException);
    }

    void onSingleFetchCompleted(T t, long l) {
        this.manifest = t;
        this.manifestLoadStartTimestamp = l;
        this.manifestLoadCompleteTimestamp = SystemClock.elapsedRealtime();
    }

    private long getRetryDelayMillis(long l) {
        return Math.min((l - 1L) * 1000L, 5000L);
    }

    private void notifyManifestRefreshStarted() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestRefreshStarted();
                }
            });
        }
    }

    private void notifyManifestRefreshed() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestRefreshed();
                }
            });
        }
    }

    private void notifyManifestError(final IOException iOException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ManifestFetcher.this.eventListener.onManifestError(iOException);
                }
            });
        }
    }

    private class SingleFetchHelper
    implements Loader.Callback {
        private final UriLoadable<T> singleUseLoadable;
        private final Looper callbackLooper;
        private final ManifestCallback<T> wrappedCallback;
        private final Loader singleUseLoader;
        private long loadStartTimestamp;

        public SingleFetchHelper(UriLoadable<T> uriLoadable, Looper looper, ManifestCallback<T> manifestCallback) {
            this.singleUseLoadable = uriLoadable;
            this.callbackLooper = looper;
            this.wrappedCallback = manifestCallback;
            this.singleUseLoader = new Loader("manifestLoader:single");
        }

        public void startLoading() {
            this.loadStartTimestamp = SystemClock.elapsedRealtime();
            this.singleUseLoader.startLoading(this.callbackLooper, this.singleUseLoadable, this);
        }

        @Override
        public void onLoadCompleted(Loader.Loadable loadable) {
            try {
                Object t = this.singleUseLoadable.getResult();
                ManifestFetcher.this.onSingleFetchCompleted(t, this.loadStartTimestamp);
                this.wrappedCallback.onSingleManifest(t);
            }
            finally {
                this.releaseLoader();
            }
        }

        @Override
        public void onLoadCanceled(Loader.Loadable loadable) {
            try {
                ManifestIOException manifestIOException = new ManifestIOException(new CancellationException());
                this.wrappedCallback.onSingleManifestError(manifestIOException);
            }
            finally {
                this.releaseLoader();
            }
        }

        @Override
        public void onLoadError(Loader.Loadable loadable, IOException iOException) {
            try {
                this.wrappedCallback.onSingleManifestError(iOException);
            }
            finally {
                this.releaseLoader();
            }
        }

        private void releaseLoader() {
            this.singleUseLoader.release();
        }
    }

    public static interface RedirectingManifest {
        public String getNextManifestUri();
    }

    public static interface ManifestCallback<T> {
        public void onSingleManifest(T var1);

        public void onSingleManifestError(IOException var1);
    }

    public static interface EventListener {
        public void onManifestRefreshStarted();

        public void onManifestRefreshed();

        public void onManifestError(IOException var1);
    }

    public static final class ManifestIOException
    extends IOException {
        public ManifestIOException(Throwable throwable) {
            super(throwable);
        }
    }
}

