/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import java.util.Arrays;

public final class LongArray {
    private static final int DEFAULT_INITIAL_CAPACITY = 32;
    private int size;
    private long[] values;

    public LongArray() {
        this(32);
    }

    public LongArray(int n) {
        this.values = new long[n];
    }

    public void add(long l) {
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.size * 2);
        }
        this.values[this.size++] = l;
    }

    public long get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Invalid size " + n + ", size is " + this.size);
        }
        return this.values[n];
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }
}

