/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import com.google.android.exoplayer.util.Util;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CacheSpan
implements Comparable<CacheSpan> {
    private static final String SUFFIX = ".v2.exo";
    private static final Pattern CACHE_FILE_PATTERN_V1 = Pattern.compile("^(.+)\\.(\\d+)\\.(\\d+)\\.v1\\.exo$");
    private static final Pattern CACHE_FILE_PATTERN_V2 = Pattern.compile("^(.+)\\.(\\d+)\\.(\\d+)\\.v2\\.exo$");
    public final String key;
    public final long position;
    public final long length;
    public final boolean isCached;
    public final File file;
    public final long lastAccessTimestamp;

    public static File getCacheFileName(File file, String string, long l, long l2) {
        return new File(file, Util.escapeFileName(string) + "." + l + "." + l2 + SUFFIX);
    }

    public static CacheSpan createLookup(String string, long l) {
        return new CacheSpan(string, l, -1L, false, -1L, null);
    }

    public static CacheSpan createOpenHole(String string, long l) {
        return new CacheSpan(string, l, -1L, false, -1L, null);
    }

    public static CacheSpan createClosedHole(String string, long l, long l2) {
        return new CacheSpan(string, l, l2, false, -1L, null);
    }

    public static CacheSpan createCacheEntry(File file) {
        Matcher matcher = CACHE_FILE_PATTERN_V2.matcher(file.getName());
        if (!matcher.matches()) {
            return null;
        }
        String string = Util.unescapeFileName(matcher.group(1));
        return string == null ? null : CacheSpan.createCacheEntry(string, Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)), file);
    }

    static File upgradeIfNeeded(File file) {
        Matcher matcher = CACHE_FILE_PATTERN_V1.matcher(file.getName());
        if (!matcher.matches()) {
            return file;
        }
        String string = matcher.group(1);
        File file2 = CacheSpan.getCacheFileName(file.getParentFile(), string, Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)));
        file.renameTo(file2);
        return file2;
    }

    private static CacheSpan createCacheEntry(String string, long l, long l2, File file) {
        return new CacheSpan(string, l, file.length(), true, l2, file);
    }

    CacheSpan(String string, long l, long l2, boolean bl, long l3, File file) {
        this.key = string;
        this.position = l;
        this.length = l2;
        this.isCached = bl;
        this.file = file;
        this.lastAccessTimestamp = l3;
    }

    public boolean isOpenEnded() {
        return this.length == -1L;
    }

    public CacheSpan touch() {
        long l = System.currentTimeMillis();
        File file = CacheSpan.getCacheFileName(this.file.getParentFile(), this.key, this.position, l);
        this.file.renameTo(file);
        return CacheSpan.createCacheEntry(this.key, this.position, l, file);
    }

    @Override
    public int compareTo(CacheSpan cacheSpan) {
        if (!this.key.equals(cacheSpan.key)) {
            return this.key.compareTo(cacheSpan.key);
        }
        long l = this.position - cacheSpan.position;
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    }
}

