/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class CacheDataSink
implements DataSink {
    private final Cache cache;
    private final long maxCacheFileSize;
    private DataSpec dataSpec;
    private File file;
    private FileOutputStream outputStream;
    private long outputStreamBytesWritten;
    private long dataSpecBytesWritten;

    public CacheDataSink(Cache cache, long l) {
        this.cache = Assertions.checkNotNull(cache);
        this.maxCacheFileSize = l;
    }

    @Override
    public DataSink open(DataSpec dataSpec) throws CacheDataSinkException {
        Assertions.checkState(dataSpec.length != -1L);
        try {
            this.dataSpec = dataSpec;
            this.dataSpecBytesWritten = 0L;
            this.openNextOutputStream();
            return this;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CacheDataSinkException(fileNotFoundException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws CacheDataSinkException {
        try {
            int n3 = 0;
            while (n3 < n2) {
                if (this.outputStreamBytesWritten == this.maxCacheFileSize) {
                    this.closeCurrentOutputStream();
                    this.openNextOutputStream();
                }
                int n4 = (int)Math.min((long)(n2 - n3), this.maxCacheFileSize - this.outputStreamBytesWritten);
                this.outputStream.write(byArray, n + n3, n4);
                n3 += n4;
                this.outputStreamBytesWritten += (long)n4;
                this.dataSpecBytesWritten += (long)n4;
            }
        }
        catch (IOException iOException) {
            throw new CacheDataSinkException(iOException);
        }
    }

    @Override
    public void close() throws CacheDataSinkException {
        try {
            this.closeCurrentOutputStream();
        }
        catch (IOException iOException) {
            throw new CacheDataSinkException(iOException);
        }
    }

    private void openNextOutputStream() throws FileNotFoundException {
        this.file = this.cache.startFile(this.dataSpec.key, this.dataSpec.absoluteStreamPosition + this.dataSpecBytesWritten, Math.min(this.dataSpec.length - this.dataSpecBytesWritten, this.maxCacheFileSize));
        this.outputStream = new FileOutputStream(this.file);
        this.outputStreamBytesWritten = 0L;
    }

    private void closeCurrentOutputStream() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        boolean bl = false;
        try {
            this.outputStream.flush();
            this.outputStream.getFD().sync();
            bl = true;
        }
        finally {
            Util.closeQuietly(this.outputStream);
            if (bl) {
                this.cache.commitFile(this.file);
            } else {
                this.file.delete();
            }
            this.outputStream = null;
            this.file = null;
        }
    }

    public static class CacheDataSinkException
    extends IOException {
        public CacheDataSinkException(IOException iOException) {
            super(iOException);
        }
    }
}

