/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class TeeDataSource
implements DataSource {
    private final DataSource upstream;
    private final DataSink dataSink;

    public TeeDataSource(DataSource dataSource, DataSink dataSink) {
        this.upstream = Assertions.checkNotNull(dataSource);
        this.dataSink = Assertions.checkNotNull(dataSink);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        long l = this.upstream.open(dataSpec);
        if (dataSpec.length == -1L && l != -1L) {
            dataSpec = new DataSpec(dataSpec.uri, dataSpec.absoluteStreamPosition, dataSpec.position, l, dataSpec.key, dataSpec.flags);
        }
        this.dataSink.open(dataSpec);
        return l;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.upstream.read(byArray, n, n2);
        if (n3 > 0) {
            this.dataSink.write(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        try {
            this.upstream.close();
        }
        finally {
            this.dataSink.close();
        }
    }
}

