/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NetworkLock;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class PriorityDataSource
implements DataSource {
    private final DataSource upstream;
    private final int priority;

    public PriorityDataSource(int n, DataSource dataSource) {
        this.priority = n;
        this.upstream = Assertions.checkNotNull(dataSource);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        NetworkLock.instance.proceedOrThrow(this.priority);
        return this.upstream.open(dataSpec);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        NetworkLock.instance.proceedOrThrow(this.priority);
        return this.upstream.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.upstream.close();
    }
}

