/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.util.Predicate;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends UriDataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = new Predicate<String>(){

        @Override
        public boolean evaluate(String string) {
            return !TextUtils.isEmpty((CharSequence)(string = Util.toLowerInvariant(string))) && (!string.contains("text") || string.contains("text/vtt")) && !string.contains("html") && !string.contains("xml");
        }
    };

    @Override
    public long open(DataSpec var1) throws HttpDataSourceException;

    @Override
    public void close() throws HttpDataSourceException;

    @Override
    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    public void setRequestProperty(String var1, String var2);

    public void clearRequestProperty(String var1);

    public void clearAllRequestProperties();

    public Map<String, List<String>> getResponseHeaders();

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final int responseCode;
        public final Map<String, List<String>> headerFields;

        public InvalidResponseCodeException(int n, Map<String, List<String>> map, DataSpec dataSpec) {
            super("Response code: " + n, dataSpec);
            this.responseCode = n;
            this.headerFields = map;
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String string, DataSpec dataSpec) {
            super("Invalid content type: " + string, dataSpec);
            this.contentType = string;
        }
    }

    public static class HttpDataSourceException
    extends IOException {
        public final DataSpec dataSpec;

        public HttpDataSourceException(DataSpec dataSpec) {
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(String string, DataSpec dataSpec) {
            super(string);
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(IOException iOException, DataSpec dataSpec) {
            super(iOException);
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(String string, IOException iOException, DataSpec dataSpec) {
            super(string, iOException);
            this.dataSpec = dataSpec;
        }
    }
}

