/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileDataSource
implements UriDataSource {
    private final TransferListener listener;
    private RandomAccessFile file;
    private String uriString;
    private long bytesRemaining;
    private boolean opened;

    public FileDataSource() {
        this(null);
    }

    public FileDataSource(TransferListener transferListener) {
        this.listener = transferListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            this.file = new RandomAccessFile(dataSpec.uri.getPath(), "r");
            this.file.seek(dataSpec.position);
            long l = this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            if (this.bytesRemaining < 0L) {
                throw new EOFException();
            }
        }
        catch (IOException iOException) {
            throw new FileDataSourceException(iOException);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws FileDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n3 = 0;
        try {
            n3 = this.file.read(byArray, n, (int)Math.min(this.bytesRemaining, (long)n2));
        }
        catch (IOException iOException) {
            throw new FileDataSourceException(iOException);
        }
        if (n3 > 0) {
            this.bytesRemaining -= (long)n3;
            if (this.listener != null) {
                this.listener.onBytesTransferred(n3);
            }
        }
        return n3;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    @Override
    public void close() throws FileDataSourceException {
        this.uriString = null;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                throw new FileDataSourceException(iOException);
            }
            finally {
                this.file = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException iOException) {
            super(iOException);
        }
    }
}

