/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class ByteArrayDataSource
implements DataSource {
    private final byte[] data;
    private int readPosition;
    private int remainingBytes;

    public ByteArrayDataSource(byte[] byArray) {
        Assertions.checkNotNull(byArray);
        Assertions.checkArgument(byArray.length > 0);
        this.data = byArray;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.readPosition = (int)dataSpec.position;
        this.remainingBytes = (int)(dataSpec.length == -1L ? (long)this.data.length - dataSpec.position : dataSpec.length);
        if (this.remainingBytes <= 0 || this.readPosition + this.remainingBytes > this.data.length) {
            throw new IOException("Unsatisfiable range: [" + this.readPosition + ", " + dataSpec.length + "], length: " + this.data.length);
        }
        return this.remainingBytes;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remainingBytes == 0) {
            return -1;
        }
        n2 = Math.min(n2, this.remainingBytes);
        System.arraycopy(this.data, this.readPosition, byArray, n, n2);
        this.readPosition += n2;
        this.remainingBytes -= n2;
        return n2;
    }
}

